/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation;

import adams.core.ClassLister;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.RoundingUtils;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.PNGImageReader;
import adams.env.Environment;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseToggleButton;
import adams.gui.core.CheckedTextField;
import adams.gui.core.ConsolePanel;
import adams.gui.core.Cursors;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.event.UndoEvent;
import adams.gui.event.UndoListener;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.segmentation.CanvasPanel;
import adams.gui.visualization.segmentation.layer.LayerManager;
import adams.gui.visualization.segmentation.layer.OverlayLayer;
import adams.gui.visualization.segmentation.tool.AbstractTool;
import adams.gui.visualization.segmentation.tool.Pointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SegmentationPanel
extends BasePanel
implements ChangeListener,
UndoListener {
    private static final long serialVersionUID = -7354416525309860289L;
    public static final double ZOOM_FACTOR = 1.4;
    protected LayerManager m_Manager;
    protected NumberTextField m_TextZoom;
    protected BaseFlatButton m_ButtonZoomClear;
    protected BaseFlatButton m_ButtonZoomIn;
    protected BaseFlatButton m_ButtonZoomOut;
    protected BaseFlatButton m_ButtonZoomBestFit;
    protected BaseFlatButton m_ButtonZoom;
    protected BaseFlatButton m_ButtonAddUndo;
    protected BaseFlatButton m_ButtonUndo;
    protected BaseFlatButton m_ButtonRedo;
    protected BaseSplitPane m_SplitPaneLeft;
    protected BaseSplitPane m_SplitPaneRight;
    protected BasePanel m_PanelLeft;
    protected BasePanel m_PanelLayers;
    protected BasePanel m_PanelTools;
    protected BaseSplitPane m_SplitPaneTools;
    protected BasePanel m_PanelToolOptions;
    protected BasePanel m_PanelCenter;
    protected BaseScrollPane m_ScrollPane;
    protected CanvasPanel m_PanelCanvas;
    protected MouseListener m_LastMouseListener;
    protected MouseMotionListener m_LastMouseMotionListener;
    protected AbstractTool m_ActiveTool;
    protected JPanel m_PanelToolButtons;

    protected void initialize() {
        super.initialize();
        this.m_LastMouseListener = null;
        this.m_LastMouseMotionListener = null;
        this.m_ActiveTool = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add(panel, "North");
        this.m_TextZoom = new NumberTextField(NumberTextField.Type.DOUBLE, "100");
        this.m_TextZoom.setColumns(5);
        this.m_TextZoom.setToolTipText("100 = original image size");
        this.m_TextZoom.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.DOUBLE, (Number)1.0, null));
        this.m_TextZoom.addAnyChangeListener(e -> this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate_blue.png")));
        JLabel label = new JLabel("Zoom");
        label.setDisplayedMnemonic('Z');
        label.setLabelFor((Component)this.m_TextZoom);
        panel.add(Fonts.usePlain((Component)label));
        panel.add((Component)this.m_TextZoom);
        this.m_ButtonZoom = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_ButtonZoom.setToolTipText("Apply zoom");
        this.m_ButtonZoom.addActionListener(e -> {
            this.m_Manager.setZoom(this.m_TextZoom.getValue().doubleValue() / 100.0);
            this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
            this.m_Manager.update();
        });
        panel.add((Component)this.m_ButtonZoom);
        this.m_ButtonZoomClear = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_clear.png"));
        this.m_ButtonZoomClear.setToolTipText("Clear zoom");
        this.m_ButtonZoomClear.addActionListener(e -> this.clearZoom());
        panel.add((Component)this.m_ButtonZoomClear);
        this.m_ButtonZoomIn = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_in.png"));
        this.m_ButtonZoomIn.setToolTipText("Zoom in");
        this.m_ButtonZoomIn.addActionListener(e -> this.zoomIn());
        panel.add((Component)this.m_ButtonZoomIn);
        this.m_ButtonZoomOut = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_out.png"));
        this.m_ButtonZoomOut.setToolTipText("Zoom out");
        this.m_ButtonZoomOut.addActionListener(e -> this.zoomOut());
        panel.add((Component)this.m_ButtonZoomOut);
        this.m_ButtonZoomBestFit = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_fit.png"));
        this.m_ButtonZoomBestFit.setToolTipText("Best fit");
        this.m_ButtonZoomBestFit.addActionListener(e -> this.bestFitZoom());
        panel.add((Component)this.m_ButtonZoomBestFit);
        panel.add(new JLabel(" "));
        this.m_ButtonAddUndo = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"undo_add.gif"));
        this.m_ButtonAddUndo.setToolTipText("Add undo point");
        this.m_ButtonAddUndo.addActionListener(e -> this.addUndoPoint());
        panel.add((Component)this.m_ButtonAddUndo);
        this.m_ButtonUndo = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"undo.gif"));
        this.m_ButtonUndo.setToolTipText("Undo changes");
        this.m_ButtonUndo.addActionListener(e -> this.undo());
        panel.add((Component)this.m_ButtonUndo);
        this.m_ButtonRedo = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"redo.gif"));
        this.m_ButtonRedo.setToolTipText("Redo changes");
        this.m_ButtonRedo.addActionListener(e -> this.redo());
        panel.add((Component)this.m_ButtonRedo);
        this.m_SplitPaneLeft = new BaseSplitPane(1);
        this.m_SplitPaneLeft.setResizeWeight(0.0);
        this.m_SplitPaneLeft.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPaneLeft, "Center");
        this.m_PanelLeft = new BasePanel((LayoutManager)new BorderLayout());
        this.m_SplitPaneLeft.setLeftComponent((Component)this.m_PanelLeft);
        this.m_PanelLayers = new BasePanel();
        this.m_PanelLayers.setBorder((Border)BorderFactory.createTitledBorder("Layers"));
        this.m_PanelLeft.add((Component)this.m_PanelLayers, (Object)"Center");
        this.m_SplitPaneRight = new BaseSplitPane(1);
        this.m_SplitPaneRight.setResizeWeight(1.0);
        this.m_SplitPaneRight.setOneTouchExpandable(true);
        this.m_SplitPaneLeft.setRightComponent((Component)this.m_SplitPaneRight);
        this.m_PanelTools = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelTools.setBorder((Border)BorderFactory.createTitledBorder("Tools"));
        this.m_SplitPaneRight.setRightComponent((Component)this.m_PanelTools);
        this.m_SplitPaneTools = new BaseSplitPane(0);
        this.m_PanelTools.add((Component)this.m_SplitPaneTools, (Object)"Center");
        this.m_PanelToolButtons = new JPanel(new GridLayout(0, 4, 5, 5));
        this.m_SplitPaneTools.setTopComponent((Component)this.m_PanelToolButtons);
        this.m_PanelToolOptions = new BasePanel((LayoutManager)new BorderLayout());
        this.m_SplitPaneTools.setBottomComponent((Component)this.m_PanelToolOptions);
        Class[] tools = ClassLister.getSingleton().getClasses(AbstractTool.class);
        ButtonGroup group = new ButtonGroup();
        BaseToggleButton buttonPointer = null;
        for (Class t : tools) {
            try {
                AbstractTool tool = (AbstractTool)t.newInstance();
                tool.setCanvas(this.m_PanelCanvas);
                BaseToggleButton button = new BaseToggleButton(tool.getIcon());
                button.setToolTipText(tool.getName());
                button.addActionListener(e -> {
                    if (this.m_LastMouseListener != null) {
                        this.m_PanelCanvas.removeMouseListener(this.m_LastMouseListener);
                    }
                    if (this.m_LastMouseMotionListener != null) {
                        this.m_PanelCanvas.removeMouseMotionListener(this.m_LastMouseMotionListener);
                    }
                    this.m_PanelToolOptions.removeAll();
                    tool.setCanvas(this.m_PanelCanvas);
                    this.m_PanelToolOptions.add((Component)tool.getOptionPanel(), (Object)"Center");
                    this.m_PanelCanvas.setCursor(tool.getCursor());
                    this.m_LastMouseListener = tool.getMouseListener();
                    if (this.m_LastMouseListener != null) {
                        this.m_PanelCanvas.addMouseListener(this.m_LastMouseListener);
                    }
                    this.m_LastMouseMotionListener = tool.getMouseMotionListener();
                    if (this.m_LastMouseMotionListener != null) {
                        this.m_PanelCanvas.addMouseMotionListener(this.m_LastMouseMotionListener);
                    }
                    this.m_SplitPaneTools.setDividerLocation(this.m_SplitPaneTools.getDividerLocation());
                    this.m_ActiveTool = tool;
                });
                group.add((AbstractButton)button);
                if (t.equals(Pointer.class)) {
                    this.m_PanelToolButtons.add((Component)button, 0);
                    buttonPointer = button;
                    continue;
                }
                this.m_PanelToolButtons.add((Component)button);
            }
            catch (Exception e2) {
                ConsolePanel.getSingleton().append("Failed to instantiate tool class: " + t.getName(), (Throwable)e2);
            }
        }
        this.m_PanelCenter = new BasePanel((LayoutManager)new BorderLayout());
        this.m_SplitPaneRight.setLeftComponent((Component)this.m_PanelCenter);
        this.m_PanelCanvas = new CanvasPanel();
        this.m_PanelCanvas.setOwner(this);
        this.m_ScrollPane = new BaseScrollPane((Component)((Object)this.m_PanelCanvas));
        this.m_PanelCenter.add((Component)this.m_ScrollPane);
        this.m_Manager = new LayerManager(this.m_PanelCanvas);
        this.m_Manager.addChangeListener(this);
        this.m_Manager.getUndo().addUndoListener((UndoListener)this);
        this.m_SplitPaneLeft.setDividerLocation(280);
        this.m_SplitPaneRight.setDividerLocation(680);
        if (buttonPointer != null) {
            buttonPointer.doClick();
        }
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    public LayerManager getManager() {
        return this.m_Manager;
    }

    public BaseScrollPane getScrollPane() {
        return this.m_ScrollPane;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.m_PanelLayers.removeAll();
        Object outer = this.m_PanelLayers;
        for (JComponent jComponent : this.m_Manager.getLayers()) {
            outer.add((Component)jComponent, "North");
            JPanel nested = new JPanel(new BorderLayout());
            outer.add((Component)nested, "Center");
            outer = nested;
        }
        int location = this.m_SplitPaneLeft.getDividerLocation();
        this.m_SplitPaneLeft.setLeftComponent((Component)this.m_PanelLeft);
        this.m_SplitPaneLeft.setDividerLocation(location);
        boolean hasActive = false;
        if (this.getManager().hasActiveOverlay()) {
            hasActive = true;
        }
        if (this.getManager().getCombinedLayer() != null && this.getManager().getCombinedLayer().hasActiveSubLayer()) {
            hasActive = true;
        }
        if (!hasActive) {
            this.m_PanelCanvas.setCursor(Cursors.disabled());
        } else if (this.m_ActiveTool != null) {
            this.m_PanelCanvas.setCursor(this.m_ActiveTool.getCursor());
        } else {
            this.m_PanelCanvas.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void updateButtons() {
        this.m_ButtonZoom.setEnabled(this.getManager().getImageLayer().getImage() != null);
        this.m_ButtonAddUndo.setEnabled(this.getManager().isUndoSupported());
        this.m_ButtonUndo.setEnabled(this.getManager().getUndo().canUndo());
        this.m_ButtonRedo.setEnabled(this.getManager().getUndo().canRedo());
    }

    public void addUndoPoint() {
        this.getManager().addUndoPoint(new Date().toString());
        this.updateButtons();
    }

    public void undo() {
        this.getManager().undo();
    }

    public void redo() {
        this.getManager().redo();
    }

    public void undoOccurred(UndoEvent e) {
        this.updateButtons();
    }

    public void update() {
        this.invalidate();
        this.doLayout();
        this.repaint();
        this.updateButtons();
        this.getManager().update();
    }

    public void setZoom(double value) {
        this.m_TextZoom.setValue((Number)value);
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_Manager.setZoom(this.m_TextZoom.getValue().doubleValue() / 100.0);
        this.update();
    }

    public double getZoom() {
        return this.m_TextZoom.getValue().doubleValue();
    }

    public void clearZoom() {
        this.m_TextZoom.setValue((Number)100);
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_Manager.setZoom(1.0);
        this.m_Manager.update();
    }

    public void zoomIn() {
        this.m_TextZoom.setValue((Number)RoundingUtils.round((double)(this.m_TextZoom.getValue().doubleValue() * 1.4), (int)1));
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_Manager.setZoom(this.m_TextZoom.getValue().doubleValue() / 100.0);
        this.m_Manager.update();
    }

    public void zoomOut() {
        this.m_TextZoom.setValue((Number)RoundingUtils.round((double)(this.m_TextZoom.getValue().doubleValue() / 1.4), (int)1));
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_Manager.setZoom(this.m_TextZoom.getValue().doubleValue() / 100.0);
        this.m_Manager.update();
    }

    public void bestFitZoom() {
        this.m_Manager.bestFitZoom();
        this.m_TextZoom.setValue((Number)RoundingUtils.round((double)(this.m_Manager.getZoom() * 100.0), (int)1));
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
    }

    public void setLeftDividerLocation(int value) {
        this.m_SplitPaneLeft.setDividerLocation(value);
    }

    public void setLeftDividerLocation(double value) {
        this.m_SplitPaneLeft.setDividerLocation(value);
    }

    public int getLeftDividerLocation() {
        return this.m_SplitPaneLeft.getDividerLocation();
    }

    public void setRightDividerLocation(int value) {
        this.m_SplitPaneRight.setDividerLocation(value);
    }

    public void setRightDividerLocation(double value) {
        this.m_SplitPaneRight.setDividerLocation(value);
    }

    public int getRightDividerLocation() {
        return this.m_SplitPaneRight.getDividerLocation();
    }

    public void setToolButtonColumns(int columns) {
        ((GridLayout)this.m_PanelToolButtons.getLayout()).setColumns(columns);
    }

    public int getToolButtonColumns() {
        return ((GridLayout)this.m_PanelToolButtons.getLayout()).getColumns();
    }

    public void setAutomaticUndoEnabled(boolean value) {
        this.m_ButtonAddUndo.setVisible(!value);
    }

    public boolean isAutomaticUndoEnabled() {
        return !this.m_ButtonAddUndo.isVisible();
    }

    protected static SegmentationPanel overlayTest(String[] args) {
        SegmentationPanel panel = new SegmentationPanel();
        panel.getManager().setSplitLayers(true);
        panel.getManager().clear();
        File img = new File(args[0]);
        panel.getManager().setImage(img.getName(), (BufferedImage)BufferedImageHelper.read((File)img).getImage());
        DefaultColorProvider provider = new DefaultColorProvider();
        for (int i = 1; i < args.length; ++i) {
            File ovl = new File(args[i]);
            String label = FileUtils.replaceExtension((String)ovl.getName(), (String)"").replaceAll(".*-", "");
            OverlayLayer layer = panel.getManager().addOverlay(label, provider.next(), 0.5f, (BufferedImage)((BufferedImageContainer)new PNGImageReader().read(new PlaceholderFile(ovl))).getImage());
            layer.setRemovable(true);
            layer.setActionsAvailable(true);
        }
        panel.setToolButtonColumns(2);
        return panel;
    }

    protected static SegmentationPanel combinedTest(String[] args) {
        SegmentationPanel panel = new SegmentationPanel();
        panel.getManager().setSplitLayers(false);
        panel.getManager().clear();
        File img = new File(args[0]);
        panel.getManager().setImage(img.getName(), (BufferedImage)BufferedImageHelper.read((File)img).getImage());
        DefaultColorProvider provider = new DefaultColorProvider();
        for (int i = 1; i < args.length; ++i) {
            File ovl = new File(args[i]);
            String label = FileUtils.replaceExtension((String)ovl.getName(), (String)"").replaceAll(".*-", "");
            panel.getManager().addCombined(label, provider.next(), 0.5f, (BufferedImage)((BufferedImageContainer)new PNGImageReader().read(new PlaceholderFile(ovl))).getImage());
        }
        panel.setToolButtonColumns(2);
        return panel;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SegmentationPanel panel = SegmentationPanel.combinedTest(args);
        panel.update();
        BaseFrame frame = new BaseFrame("Segmentation");
        frame.setDefaultCloseOperation(3);
        frame.setSize(GUIHelper.makeWider((Dimension)GUIHelper.getDefaultLargeDialogDimension()));
        frame.setLocationRelativeTo(null);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)panel), "Center");
        frame.setVisible(true);
    }
}

