/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.layer;

import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.segmentation.layer.LayerManager;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;

public abstract class AbstractLayer
extends BasePanel {
    private static final long serialVersionUID = -3811495263799661072L;
    protected LayerManager m_Manager;
    protected BaseCheckBox m_CheckboxEnabled;

    protected void initGUI() {
        super.initGUI();
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.m_CheckboxEnabled = new BaseCheckBox();
        this.m_CheckboxEnabled.setSelected(true);
        this.m_CheckboxEnabled.setToolTipText("Toggle visibility of layer");
        this.m_CheckboxEnabled.addActionListener(e -> this.update());
    }

    public void setManager(LayerManager value) {
        this.m_Manager = value;
    }

    public LayerManager getManager() {
        return this.m_Manager;
    }

    public abstract String getName();

    public void setEnabled(boolean value) {
        this.m_CheckboxEnabled.setSelected(value);
    }

    public boolean isEnabled() {
        return this.m_CheckboxEnabled.isSelected();
    }

    public abstract boolean isRemovable();

    public abstract boolean hasActionsAvailable();

    protected void update() {
        if (this.m_Manager != null) {
            this.m_Manager.update();
        }
    }

    protected abstract void doDraw(Graphics2D var1);

    public void draw(Graphics2D g2d) {
        if (this.isEnabled()) {
            this.doDraw(g2d);
        }
    }

    public abstract AbstractLayerState getState();

    public abstract void setState(AbstractLayerState var1);

    public abstract AbstractLayerState getSettings();

    public abstract void setSettings(AbstractLayerState var1);

    public static BaseFlatButton createApplyButton() {
        BaseFlatButton result = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"validate.png"));
        result.setToolTipText("Apply current values");
        return result;
    }

    public static void setApplyButtonState(BaseFlatButton button, boolean modified) {
        if (modified) {
            button.setIcon((Icon)GUIHelper.getIcon((String)"validate_blue.png"));
        } else {
            button.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        }
    }

    public static abstract class AbstractLayerState
    implements Serializable {
        private static final long serialVersionUID = -5652014216527524598L;
        protected String name;
        protected boolean enabled;
    }
}

