/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.layer;

import adams.gui.core.BaseColorTextField;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.ColorHelper;
import adams.gui.core.Fonts;
import adams.gui.visualization.segmentation.layer.AbstractLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BackgroundLayer
extends AbstractLayer {
    private static final long serialVersionUID = 1680744036963757388L;
    public static final String LAYER_NAME = "Background";
    protected JLabel m_LabelName;
    protected BaseColorTextField m_TextColor;
    protected BaseFlatButton m_ButtonApply;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new GridLayout(0, 1));
        JPanel panelRow = new JPanel(new FlowLayout(0));
        this.add(panelRow);
        panelRow.add((Component)this.m_CheckboxEnabled);
        this.m_LabelName = new JLabel(this.getName());
        panelRow.add(Fonts.usePlain((Component)this.m_LabelName));
        panelRow = new JPanel(new FlowLayout(0));
        this.add(panelRow);
        this.m_TextColor = new BaseColorTextField(Color.BLACK);
        this.m_TextColor.setColumns(7);
        this.m_TextColor.setToolTipText("The color to use for the background");
        this.m_TextColor.addAnyChangeListener(e -> BackgroundLayer.setApplyButtonState(this.m_ButtonApply, true));
        panelRow.add((Component)this.m_TextColor);
        this.m_ButtonApply = BackgroundLayer.createApplyButton();
        this.m_ButtonApply.addActionListener(e -> this.update());
        panelRow.add((Component)this.m_ButtonApply);
    }

    @Override
    public String getName() {
        return LAYER_NAME;
    }

    public void setColor(Color value) {
        this.m_TextColor.setText(ColorHelper.toHex((Color)value));
    }

    public Color getColor() {
        return this.m_TextColor.getObject().toColorValue();
    }

    @Override
    public boolean isRemovable() {
        return false;
    }

    @Override
    public boolean hasActionsAvailable() {
        return false;
    }

    @Override
    protected void doDraw(Graphics2D g2d) {
        g2d.setColor(this.getColor());
        g2d.fillRect(0, 0, this.getManager().getWidth(), this.getManager().getHeight());
    }

    @Override
    public AbstractLayer.AbstractLayerState getState() {
        return this.getSettings();
    }

    @Override
    public void setState(AbstractLayer.AbstractLayerState state) {
        this.setSettings(state);
    }

    @Override
    public AbstractLayer.AbstractLayerState getSettings() {
        BackgroundLayerState result = new BackgroundLayerState();
        result.name = this.getName();
        result.enabled = this.isEnabled();
        result.color = this.getColor();
        return result;
    }

    @Override
    public void setSettings(AbstractLayer.AbstractLayerState settings) {
        this.setEnabled(settings.enabled);
        if (settings instanceof BackgroundLayerState) {
            this.setColor(((BackgroundLayerState)settings).color);
        }
        BackgroundLayer.setApplyButtonState(this.m_ButtonApply, false);
    }

    @Override
    protected void update() {
        BackgroundLayer.setApplyButtonState(this.m_ButtonApply, false);
        super.update();
    }

    public static class BackgroundLayerState
    extends AbstractLayer.AbstractLayerState {
        private static final long serialVersionUID = -5652014216527524598L;
        protected Color color;
    }
}

