/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.layer;

import adams.core.base.BaseFloat;
import adams.core.base.BaseObject;
import adams.data.image.BufferedImageHelper;
import adams.gui.core.BaseColorTextField;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BaseObjectTextField;
import adams.gui.core.BasePanel;
import adams.gui.visualization.segmentation.ImageUtils;
import adams.gui.visualization.segmentation.layer.AbstractImageLayer;
import adams.gui.visualization.segmentation.layer.AbstractLayer;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CombinedLayer
extends AbstractImageLayer {
    private static final long serialVersionUID = -104739528589704124L;
    public static final String LAYER_NAME = "Combined";
    protected BaseObjectTextField<BaseFloat> m_TextAlpha;
    protected float m_Alpha;
    protected BaseFlatButton m_ButtonApply;
    protected List<CombinedSubLayer> m_SubLayers;
    protected JPanel m_PanelLayers;
    protected CombinedSubLayer m_ActiveSubLayer;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_SubLayers = new ArrayList<CombinedSubLayer>();
        this.m_ActiveSubLayer = null;
        this.m_Alpha = 0.5f;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panelParams = new JPanel(new BorderLayout());
        this.add(panelParams, "North");
        JPanel panelTop = new JPanel(new GridLayout(0, 1));
        panelParams.add((Component)panelTop, "North");
        JPanel panelLayers = new JPanel(new BorderLayout());
        panelParams.add((Component)panelLayers, "Center");
        JPanel panelRow = new JPanel(new FlowLayout(0));
        panelTop.add(panelRow);
        panelRow.add(new JLabel("Overlay alpha"));
        this.m_TextAlpha = new BaseObjectTextField((BaseObject)new BaseFloat(Float.valueOf(0.5f)));
        this.m_TextAlpha.setColumns(4);
        this.m_TextAlpha.setToolTipText("fully transparent=0.0, fully opaque=1.0");
        this.m_TextAlpha.addAnyChangeListener(e -> CombinedLayer.setApplyButtonState(this.m_ButtonApply, true));
        panelRow.add((Component)this.m_TextAlpha);
        this.m_ButtonApply = CombinedLayer.createApplyButton();
        this.m_ButtonApply.addActionListener(e -> {
            this.m_Alpha = ((BaseFloat)this.m_TextAlpha.getObject()).floatValue();
            CombinedLayer.setApplyButtonState(this.m_ButtonApply, false);
            this.getManager().update();
        });
        panelRow.add((Component)this.m_ButtonApply);
        this.m_PanelLayers = new JPanel(new GridLayout(0, 1));
        panelLayers.add((Component)this.m_PanelLayers, "North");
    }

    @Override
    public void setName(String value) {
    }

    @Override
    public String getName() {
        return LAYER_NAME;
    }

    @Override
    public boolean isRemovable() {
        return false;
    }

    @Override
    public boolean hasActionsAvailable() {
        return false;
    }

    public void clear() {
        this.setImage(null);
        this.m_SubLayers.clear();
        this.m_ActiveSubLayer = null;
    }

    public CombinedSubLayer add(String name, Color color, float alpha) {
        return this.add(name, color, alpha, null);
    }

    public CombinedSubLayer add(String name, Color color, float alpha, BufferedImage image) {
        CombinedSubLayer panel = new CombinedSubLayer();
        panel.setOwner(this);
        panel.setName(name);
        panel.setColor(color);
        panel.setAlpha(alpha);
        this.m_SubLayers.add(panel);
        Color actColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
        panel.setActualColor(actColor);
        if (image != null) {
            image = image.getType() != 2 ? BufferedImageHelper.convert((BufferedImage)image, (int)2) : BufferedImageHelper.deepCopy((BufferedImage)image);
            ImageUtils.initImage(image, actColor);
        } else {
            image = ImageUtils.newImage(this.getManager().getImageLayer().getImage().getWidth(), this.getManager().getImageLayer().getImage().getHeight());
        }
        if (this.m_Image == null) {
            this.m_Image = image;
        } else {
            ImageUtils.combineImages(image, this.m_Image);
        }
        this.m_PanelLayers.removeAll();
        this.m_PanelLayers.setLayout(new GridLayout(0, 1));
        for (CombinedSubLayer l : this.m_SubLayers) {
            this.m_PanelLayers.add((Component)((Object)l));
        }
        if (this.m_SubLayers.size() == 1) {
            this.activate(panel);
        } else if (this.hasActiveSubLayer()) {
            this.activate(this.getActiveSubLayer());
        }
        return panel;
    }

    public List<CombinedSubLayer> getSubLayers() {
        return this.m_SubLayers;
    }

    public CombinedSubLayer getSubLayer(String name) {
        CombinedSubLayer result = null;
        for (CombinedSubLayer l : this.m_SubLayers) {
            if (!l.getName().equals(name)) continue;
            result = l;
            break;
        }
        return result;
    }

    public boolean hasActiveSubLayer() {
        return this.getActiveSubLayer() != null;
    }

    public CombinedSubLayer getActiveSubLayer() {
        return this.m_ActiveSubLayer;
    }

    public void activate(CombinedSubLayer layer) {
        for (CombinedSubLayer l : this.m_SubLayers) {
            if (l == layer) {
                l.setBorder(BorderFactory.createBevelBorder(1));
                continue;
            }
            l.setBorder(BorderFactory.createBevelBorder(0));
        }
        this.m_ActiveSubLayer = layer;
    }

    @Override
    protected void doDraw(Graphics2D g2d) {
        Composite original = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.m_Alpha));
        g2d.drawImage(this.m_Image, null, 0, 0);
        g2d.setComposite(original);
    }

    @Override
    public AbstractLayer.AbstractLayerState getState() {
        CombinedLayerState result = (CombinedLayerState)this.getSettings();
        result.image = BufferedImageHelper.deepCopy((BufferedImage)this.getImage());
        return result;
    }

    @Override
    public void setState(AbstractLayer.AbstractLayerState state) {
        if (state instanceof CombinedLayerState) {
            this.setImage(((CombinedLayerState)state).image);
        }
        this.setSettings(state);
    }

    @Override
    public AbstractLayer.AbstractLayerState getSettings() {
        CombinedLayerState result = new CombinedLayerState();
        result.enabled = true;
        result.name = this.getName();
        result.alpha = this.getAlpha();
        result.alphaApplied = this.m_Alpha;
        for (CombinedSubLayer l : this.m_SubLayers) {
            result.subLayers.put(l.getName(), l.getState());
            result.order.add(l.getName());
        }
        return result;
    }

    @Override
    public void setSettings(AbstractLayer.AbstractLayerState settings) {
        if (settings instanceof CombinedLayerState) {
            CombinedLayerState cstate = (CombinedLayerState)settings;
            this.setAlpha(cstate.alpha);
            this.setEnabled(true);
            CombinedLayer.setApplyButtonState(this.m_ButtonApply, false);
            this.m_Alpha = cstate.alphaApplied;
            for (String name : cstate.order) {
                CombinedSubLayerState sstate = cstate.subLayers.get(name);
                CombinedSubLayer panel = this.getSubLayer(name);
                if (panel == null) continue;
                panel.setState(sstate);
            }
        }
    }

    public void setAlpha(float value) {
        this.m_TextAlpha.setObject((BaseObject)new BaseFloat(Float.valueOf(value)));
        this.m_Alpha = value;
    }

    public float getAlpha() {
        return ((BaseFloat)this.m_TextAlpha.getObject()).floatValue();
    }

    @Override
    protected void update() {
        CombinedLayer.setApplyButtonState(this.m_ButtonApply, false);
        for (CombinedSubLayer l : this.m_SubLayers) {
            l.update();
        }
        super.update();
    }

    public static class CombinedLayerState
    extends AbstractImageLayer.AbstractImageLayerState {
        private static final long serialVersionUID = -5652014216527524598L;
        public float alpha;
        public float alphaApplied;
        public Map<String, CombinedSubLayerState> subLayers = new HashMap<String, CombinedSubLayerState>();
        public List<String> order = new ArrayList<String>();
    }

    public static class CombinedSubLayer
    extends BasePanel {
        private static final long serialVersionUID = 3535764327769203506L;
        protected CombinedLayer m_Owner;
        protected BaseFlatButton m_ButtonActivate;
        protected BaseObjectTextField<BaseFloat> m_TextAlpha;
        protected BaseColorTextField m_TextColor;
        protected BaseFlatButton m_ButtonApply;
        protected Color m_ActualColor;
        protected Color m_ActualColorOld;

        protected void initialize() {
            super.initialize();
            this.m_ActualColor = null;
            this.m_ActualColorOld = null;
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new GridLayout(0, 1));
            JPanel panelRow = new JPanel(new FlowLayout(0));
            this.add(panelRow);
            this.m_ButtonActivate = new BaseFlatButton("");
            this.m_ButtonActivate.setToolTipText("Activate layer");
            this.m_ButtonActivate.addActionListener(e -> this.getOwner().activate(this));
            panelRow.add((Component)this.m_ButtonActivate);
            panelRow = new JPanel(new FlowLayout(0));
            this.add(panelRow);
            this.m_TextAlpha = new BaseObjectTextField((BaseObject)new BaseFloat(Float.valueOf(0.5f)));
            this.m_TextAlpha.setColumns(4);
            this.m_TextAlpha.setToolTipText("fully transparent=0.0, fully opaque=1.0");
            this.m_TextAlpha.addAnyChangeListener(e -> AbstractLayer.setApplyButtonState(this.m_ButtonApply, true));
            this.m_TextAlpha.setEditable(false);
            this.m_TextColor = new BaseColorTextField(Color.RED);
            this.m_TextColor.setColumns(7);
            this.m_TextColor.setToolTipText("The color to use for this layer");
            this.m_TextColor.addAnyChangeListener(e -> AbstractLayer.setApplyButtonState(this.m_ButtonApply, true));
            this.m_TextColor.setEnabledCascade(false);
            panelRow.add((Component)this.m_TextColor);
            this.m_ButtonApply = AbstractLayer.createApplyButton();
            this.m_ButtonApply.addActionListener(e -> {
                this.m_ActualColorOld = this.m_ActualColor;
                Color c = this.getColor();
                this.m_ActualColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0f * this.getAlpha()));
                ImageUtils.replaceColor(this.getOwner().getImage(), this.m_ActualColorOld, this.m_ActualColor);
                AbstractLayer.setApplyButtonState(this.m_ButtonApply, false);
                this.getOwner().getManager().update();
            });
        }

        public void setOwner(CombinedLayer value) {
            this.m_Owner = value;
        }

        public CombinedLayer getOwner() {
            return this.m_Owner;
        }

        public void setName(String value) {
            this.m_ButtonActivate.setText(value);
        }

        public String getName() {
            return this.m_ButtonActivate.getText();
        }

        public void setColor(Color value) {
            this.m_TextColor.setColor(value);
        }

        public void setActualColor(Color value) {
            if (this.m_ActualColor != null && this.m_ActualColor.getRGB() != value.getRGB()) {
                ImageUtils.replaceColor(this.getOwner().getImage(), this.m_ActualColor, value);
            }
            this.m_ActualColor = value;
        }

        public Color getColor() {
            return this.m_TextColor.getColor();
        }

        public void setAlpha(float value) {
            this.m_TextAlpha.setObject((BaseObject)new BaseFloat(Float.valueOf(value)));
        }

        public float getAlpha() {
            return ((BaseFloat)this.m_TextAlpha.getObject()).floatValue();
        }

        public void update() {
            AbstractLayer.setApplyButtonState(this.m_ButtonApply, false);
        }

        public BufferedImage getImage() {
            BufferedImage image = this.getOwner().getImage();
            if (image == null) {
                return null;
            }
            BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            int rgb = this.getColor().getRGB();
            int black = Color.BLACK.getRGB();
            int[] pixelsOld = this.getOwner().getImage().getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
            int[] pixelsNew = new int[pixelsOld.length];
            for (int i = 0; i < pixelsOld.length; ++i) {
                pixelsNew[i] = pixelsOld[i] == rgb ? rgb : black;
            }
            result.setRGB(0, 0, result.getWidth(), result.getHeight(), pixelsNew, 0, result.getWidth());
            return result;
        }

        public BufferedImage getBinaryImage() {
            BufferedImage image = this.getImage();
            if (image == null) {
                return null;
            }
            ImageUtils.initImage(image, Color.WHITE);
            return BufferedImageHelper.convert((BufferedImage)image, (int)12);
        }

        public CombinedSubLayerState getState() {
            CombinedSubLayerState result = new CombinedSubLayerState();
            result.name = this.getName();
            result.enabled = true;
            result.active = this.getOwner().getActiveSubLayer() == this;
            result.color = this.getColor();
            result.alpha = this.getAlpha();
            result.actualColor = this.m_ActualColor;
            result.actualColorOld = this.m_ActualColorOld;
            return result;
        }

        public void setState(CombinedSubLayerState state) {
            if (state.active) {
                this.getOwner().activate(this);
            }
            AbstractLayer.setApplyButtonState(this.m_ButtonApply, false);
        }
    }

    public static class CombinedSubLayerState
    extends AbstractLayer.AbstractLayerState {
        private static final long serialVersionUID = -5652014216527524598L;
        public Color color;
        public float alpha;
        public boolean active;
        public Color actualColor;
        public Color actualColorOld;
    }
}

