/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.layer;

import adams.data.image.BufferedImageHelper;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.CheckedTextField;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.visualization.segmentation.layer.AbstractImageLayer;
import adams.gui.visualization.segmentation.layer.AbstractLayer;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageLayer
extends AbstractImageLayer {
    private static final long serialVersionUID = 1680744036963757388L;
    public static final String LAYER_NAME = "Image";
    protected JLabel m_LabelName;
    protected BaseFlatButton m_ButtonName;
    protected NumberTextField m_TextBrightness;
    protected BaseFlatButton m_ButtonApply;
    protected Float m_LastBrightness;
    protected BufferedImage m_BrightImage;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_BrightImage = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new GridLayout(0, 1));
        JPanel panelRow = new JPanel(new FlowLayout(0));
        this.add(panelRow);
        panelRow.add((Component)this.m_CheckboxEnabled);
        this.m_LabelName = new JLabel("");
        panelRow.add(Fonts.usePlain((Component)this.m_LabelName));
        this.m_ButtonName = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"copy.gif"));
        this.m_ButtonName.addActionListener(e -> ClipboardHelper.copyToClipboard((String)this.m_LabelName.getText()));
        this.m_ButtonName.setToolTipText("Copy name to clipboard");
        panelRow.add((Component)this.m_ButtonName);
        panelRow = new JPanel(new FlowLayout(0));
        this.add(panelRow);
        panelRow.add(Fonts.usePlain((Component)new JLabel("Brightness")));
        this.m_TextBrightness = new NumberTextField(NumberTextField.Type.DOUBLE, "100");
        this.m_TextBrightness.setColumns(5);
        this.m_TextBrightness.setToolTipText("100 = original brightness");
        this.m_TextBrightness.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.DOUBLE, (Number)1.0, null));
        this.m_TextBrightness.addAnyChangeListener(e -> ImageLayer.setApplyButtonState(this.m_ButtonApply, true));
        panelRow.add((Component)this.m_TextBrightness);
        this.m_ButtonApply = ImageLayer.createApplyButton();
        this.m_ButtonApply.addActionListener(e -> this.update());
        panelRow.add((Component)this.m_ButtonApply);
    }

    @Override
    public void setName(String value) {
        this.m_LabelName.setText(value);
    }

    @Override
    public String getName() {
        return this.m_LabelName.getText();
    }

    @Override
    public void setImage(BufferedImage value) {
        super.setImage(value);
        this.m_BrightImage = null;
    }

    @Override
    public boolean isRemovable() {
        return false;
    }

    @Override
    public boolean hasActionsAvailable() {
        return false;
    }

    public void clear() {
        this.setImage(null);
    }

    @Override
    protected void doDraw(Graphics2D g2d) {
        float brightness = this.m_TextBrightness.getValue().floatValue();
        if (this.m_BrightImage == null || this.m_LastBrightness == null || this.m_LastBrightness.floatValue() != brightness) {
            RescaleOp op = new RescaleOp(brightness / 100.0f, 0.0f, null);
            this.m_BrightImage = new BufferedImage(this.m_Image.getWidth(), this.m_Image.getHeight(), this.m_Image.getType());
            BufferedImage image = this.m_Image;
            if (this.m_Image.getType() == 13) {
                image = BufferedImageHelper.convert((BufferedImage)this.m_Image, (int)2);
            }
            this.m_BrightImage = op.filter(image, this.m_BrightImage);
            this.m_LastBrightness = Float.valueOf(brightness);
        }
        g2d.drawImage(this.m_BrightImage, null, 0, 0);
    }

    @Override
    public AbstractLayer.AbstractLayerState getState() {
        ImageLayerState result = (ImageLayerState)this.getSettings();
        result.image = BufferedImageHelper.deepCopy((BufferedImage)this.getImage());
        return result;
    }

    @Override
    public void setState(AbstractLayer.AbstractLayerState state) {
        this.setSettings(state);
        if (state instanceof ImageLayerState) {
            this.setImage(((ImageLayerState)state).image);
        }
    }

    @Override
    public AbstractLayer.AbstractLayerState getSettings() {
        ImageLayerState result = new ImageLayerState();
        result.name = this.getName();
        result.enabled = this.isEnabled();
        return result;
    }

    @Override
    public void setSettings(AbstractLayer.AbstractLayerState settings) {
        this.setName(settings.name);
        this.setEnabled(settings.enabled);
    }

    @Override
    protected void update() {
        ImageLayer.setApplyButtonState(this.m_ButtonApply, false);
        super.update();
    }

    public static class ImageLayerState
    extends AbstractImageLayer.AbstractImageLayerState {
        private static final long serialVersionUID = -5652014216527524598L;
    }
}

