/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.layer;

import adams.core.ClassLister;
import adams.core.Utils;
import adams.core.base.BaseFloat;
import adams.core.base.BaseObject;
import adams.data.image.BufferedImageHelper;
import adams.gui.core.BaseColorTextField;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BaseFlatButtonWithDropDownMenu;
import adams.gui.core.BaseObjectTextField;
import adams.gui.core.ColorHelper;
import adams.gui.core.ConsolePanel;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.segmentation.ImageUtils;
import adams.gui.visualization.segmentation.layer.AbstractImageLayer;
import adams.gui.visualization.segmentation.layer.AbstractLayer;
import adams.gui.visualization.segmentation.layer.overlaylayeraction.AbstractOverlayLayerAction;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class OverlayLayer
extends AbstractImageLayer {
    private static final long serialVersionUID = 7829707838665930430L;
    protected BaseObjectTextField<BaseFloat> m_TextAlpha;
    protected BaseColorTextField m_TextColor;
    protected BaseFlatButton m_ButtonApply;
    protected BaseFlatButtonWithDropDownMenu m_ButtonActions;
    protected BaseFlatButton m_ButtonRemove;
    protected BaseFlatButton m_ButtonActivate;
    protected boolean m_Active;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Active = false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new GridLayout(0, 1));
        JPanel panelRow = new JPanel(new FlowLayout(0));
        this.add(panelRow);
        panelRow.add((Component)this.m_CheckboxEnabled);
        this.m_ButtonActivate = new BaseFlatButton("");
        this.m_ButtonActivate.setToolTipText("Activate layer");
        this.m_ButtonActivate.addActionListener(e -> this.getManager().activate(this));
        panelRow.add((Component)this.m_ButtonActivate);
        this.m_ButtonRemove = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"delete.gif"));
        this.m_ButtonRemove.setVisible(false);
        this.m_ButtonRemove.setToolTipText("Remove layer");
        this.m_ButtonRemove.addActionListener(e -> {
            this.getManager().removeOverlay(this.getName());
            this.update();
        });
        panelRow.add((Component)this.m_ButtonRemove);
        this.m_ButtonActions = new BaseFlatButtonWithDropDownMenu();
        this.m_ButtonActions.setVisible(false);
        for (Class cls : ClassLister.getSingleton().getClasses(AbstractOverlayLayerAction.class)) {
            try {
                AbstractOverlayLayerAction action = (AbstractOverlayLayerAction)cls.newInstance();
                JMenuItem menuitem = new JMenuItem(action.getName());
                menuitem.setIcon(action.getIcon());
                menuitem.addActionListener(e -> action.performAction(this));
                Fonts.usePlain((Component)menuitem);
                this.m_ButtonActions.addToMenu(menuitem);
            }
            catch (Exception e2) {
                ConsolePanel.getSingleton().append("Failed to instantiate overlay layer action: " + Utils.classToString((Class)cls), (Throwable)e2);
            }
        }
        this.m_ButtonActions.setToolTipText("Click to select action");
        panelRow.add((Component)this.m_ButtonActions);
        panelRow = new JPanel(new FlowLayout(0));
        this.add(panelRow);
        this.m_TextAlpha = new BaseObjectTextField((BaseObject)new BaseFloat(Float.valueOf(0.5f)));
        this.m_TextAlpha.setColumns(4);
        this.m_TextAlpha.setToolTipText("fully transparent=0.0, fully opaque=1.0");
        this.m_TextAlpha.addAnyChangeListener(e -> OverlayLayer.setApplyButtonState(this.m_ButtonApply, true));
        panelRow.add((Component)this.m_TextAlpha);
        this.m_TextColor = new BaseColorTextField(Color.RED);
        this.m_TextColor.setColumns(7);
        this.m_TextColor.setToolTipText("The color to use for the overlay");
        this.m_TextColor.addAnyChangeListener(e -> OverlayLayer.setApplyButtonState(this.m_ButtonApply, true));
        panelRow.add((Component)this.m_TextColor);
        this.m_ButtonApply = OverlayLayer.createApplyButton();
        this.m_ButtonApply.addActionListener(e -> {
            this.updateImage();
            this.update();
        });
        panelRow.add((Component)this.m_ButtonApply);
    }

    @Override
    public void setImage(BufferedImage value) {
        super.setImage(value);
        this.updateImage();
    }

    @Override
    public void setName(String value) {
        this.m_ButtonActivate.setText(value);
    }

    @Override
    public String getName() {
        return this.m_ButtonActivate.getText();
    }

    public void setAlpha(float value) {
        this.m_TextAlpha.setText("" + value);
    }

    public float getAlpha() {
        return ((BaseFloat)this.m_TextAlpha.getObject()).floatValue();
    }

    public void setColor(Color value) {
        this.m_TextColor.setText(ColorHelper.toHex((Color)value));
        this.updateImage();
    }

    public Color getColor() {
        return this.m_TextColor.getObject().toColorValue();
    }

    public void setActive(boolean value) {
        this.m_Active = value;
        if (this.m_Active) {
            this.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            this.setBorder(BorderFactory.createBevelBorder(0));
        }
    }

    public boolean isActive() {
        return this.m_Active;
    }

    @Override
    public boolean isRemovable() {
        return this.m_ButtonRemove.isVisible();
    }

    public void setRemovable(boolean value) {
        this.m_ButtonRemove.setVisible(value);
    }

    @Override
    public boolean hasActionsAvailable() {
        return this.m_ButtonActions.isVisible();
    }

    public void setActionsAvailable(boolean value) {
        this.m_ButtonActions.setVisible(value);
    }

    protected void updateImage() {
        if (this.m_Image == null) {
            return;
        }
        ImageUtils.initImage(this.m_Image, this.getColor());
    }

    public BufferedImage getBinaryImage() {
        BufferedImage result = BufferedImageHelper.deepCopy((BufferedImage)this.getImage());
        ImageUtils.initImage(result, Color.WHITE);
        return result;
    }

    @Override
    protected void doDraw(Graphics2D g2d) {
        Composite original = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        g2d.drawImage(this.m_Image, null, 0, 0);
        g2d.setComposite(original);
    }

    @Override
    public AbstractLayer.AbstractLayerState getState() {
        OverlayLayerState result = (OverlayLayerState)this.getSettings();
        result.image = BufferedImageHelper.deepCopy((BufferedImage)this.getImage());
        return result;
    }

    @Override
    public void setState(AbstractLayer.AbstractLayerState state) {
        if (state instanceof AbstractImageLayer.AbstractImageLayerState) {
            this.setImage(((AbstractImageLayer.AbstractImageLayerState)state).image);
        }
        this.setSettings(state);
    }

    @Override
    public AbstractLayer.AbstractLayerState getSettings() {
        OverlayLayerState result = new OverlayLayerState();
        result.name = this.getName();
        result.enabled = this.isEnabled();
        result.color = this.getColor();
        result.alpha = this.getAlpha();
        result.active = this.isActive();
        return result;
    }

    @Override
    public void setSettings(AbstractLayer.AbstractLayerState settings) {
        this.setName(settings.name);
        this.setEnabled(settings.enabled);
        if (settings instanceof OverlayLayerState) {
            this.setColor(((OverlayLayerState)settings).color);
            this.setAlpha(((OverlayLayerState)settings).alpha);
            this.setActive(((OverlayLayerState)settings).active);
        }
    }

    @Override
    protected void update() {
        OverlayLayer.setApplyButtonState(this.m_ButtonApply, false);
        super.update();
    }

    public static class OverlayLayerState
    extends AbstractImageLayer.AbstractImageLayerState {
        private static final long serialVersionUID = -5652014216527524598L;
        public Color color;
        public float alpha;
        public boolean active;
    }
}

