/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;
import adams.data.statistics.StatUtils;
import georegression.struct.shapes.Quadrilateral_F64;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class QuadrilateralLocation
extends AbstractBaseString {
    private static final long serialVersionUID = -5853830144343397434L;

    public QuadrilateralLocation() {
        this("0 0 0 0 0 0 0 0");
    }

    public QuadrilateralLocation(String s) {
        super(s);
    }

    public QuadrilateralLocation(Quadrilateral_F64 location) {
        this(location.a.x, location.a.y, location.b.x, location.b.y, location.c.x, location.c.y, location.d.x, location.d.y);
    }

    public QuadrilateralLocation(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        this(x0 + " " + y0 + " " + x1 + " " + y1 + " " + x2 + " " + y2 + " " + x3 + " " + y3);
    }

    public boolean isValid(String value) {
        String[] parts = (value = value.replaceAll("  ", " ")).split(" ");
        if (parts.length != 8) {
            return false;
        }
        try {
            for (String part : parts) {
                Double.parseDouble(part);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public double[] doubleValue() {
        String[] parts = this.getValue().split(" ");
        double[] result = new double[8];
        if (parts.length != 8) {
            return result;
        }
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Double.parseDouble(parts[i]);
        }
        return result;
    }

    public Quadrilateral_F64 quadrilateralValue() {
        double[] parts = this.doubleValue();
        Quadrilateral_F64 result = new Quadrilateral_F64(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5], parts[6], parts[7]);
        return result;
    }

    public Rectangle rectangleValue() {
        double[] parts = this.doubleValue();
        double[] x = new double[]{parts[0], parts[2], parts[4], parts[6]};
        double[] y = new double[]{parts[1], parts[3], parts[5], parts[7]};
        double left = StatUtils.min((double[])x);
        double right = StatUtils.max((double[])x);
        double top = StatUtils.min((double[])y);
        double bottom = StatUtils.max((double[])y);
        Rectangle result = new Rectangle((int)Math.round(left), (int)Math.round(top), (int)Math.round(right - left), (int)Math.round(bottom - top));
        return result;
    }

    public Point2D centerValue() {
        double[] parts = this.doubleValue();
        double[] x = new double[]{parts[0], parts[2], parts[4], parts[6]};
        double[] y = new double[]{parts[1], parts[3], parts[5], parts[7]};
        double left = StatUtils.min((double[])x);
        double right = StatUtils.max((double[])x);
        double top = StatUtils.min((double[])y);
        double bottom = StatUtils.max((double[])y);
        Point2D.Double result = new Point2D.Double(left + (right - left) / 2.0, top + (bottom - top) / 2.0);
        return result;
    }

    public String getTipText() {
        return "Quadrilateral location string.";
    }
}

