/*
 * Decompiled with CFR 0.152.
 */
package adams.data.barcode.encode;

import adams.data.barcode.encode.AbstractBarcodeEncoder;
import adams.data.image.BufferedImageContainer;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class EAN13
extends AbstractBarcodeEncoder {
    private static final long serialVersionUID = -5065848369849665652L;
    protected String m_Digits;

    public String globalInfo() {
        return "Draws an EAN13 barcode at a specified location and size.Digits must be 13 characters long. A valid checksum is enforced.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("digits", "digits", (Object)"0123456789012");
    }

    public String getDigits() {
        return this.m_Digits;
    }

    protected String isValidCode(String ean) {
        int check;
        if (ean == null || ean.isEmpty()) {
            return "Digits must not be null or empty.";
        }
        if (!ean.matches("\\d+")) {
            return "Value must not contain non-numeric characters, provided: " + ean;
        }
        if (ean.length() != 13) {
            return "13 digits must be present: " + ean + " (=" + ean.length() + ")";
        }
        int sum = 0;
        for (int i = 0; i < 12; ++i) {
            int c = Integer.parseInt(ean.substring(i, i + 1));
            sum += c * (i % 2 == 0 ? 1 : 3);
        }
        for (check = sum; check > 0; check -= 10) {
        }
        if ((check = Math.abs(check)) != Integer.parseInt(ean.substring(12, 13))) {
            return "Checksum digits differ: expected=" + check + ", found=" + ean.substring(12, 13);
        }
        return null;
    }

    public void setDigits(String value) {
        String check = this.isValidCode(value);
        if (check == null) {
            this.m_Digits = value;
            this.reset();
        } else {
            this.getLogger().severe(check);
        }
    }

    public String digitsTipText() {
        return "Digits to be encoded.";
    }

    @Override
    protected String doDraw(BufferedImageContainer image) {
        String result = null;
        try {
            EAN13Writer writer = new EAN13Writer();
            HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
            hints.put(EncodeHintType.MARGIN, this.m_Margin);
            BitMatrix matrix = writer.encode(this.m_Digits, BarcodeFormat.EAN_13, this.m_Width, this.m_Height, hints);
            for (int y = this.m_Y; y < this.m_Height; ++y) {
                for (int x = this.m_X; x < this.m_Width; ++x) {
                    ((BufferedImage)image.getImage()).setRGB(x, y, matrix.get(x, y) ? 0 : 0xFFFFFF);
                }
            }
        }
        catch (WriterException e) {
            result = e.getMessage();
        }
        return result;
    }
}

