/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.image.BufferedImageBitmaskContainer;
import adams.data.image.BufferedImageContainer;
import java.awt.image.BufferedImage;

public class BufferedImageBitmaskContainerToBufferedImages
extends AbstractConversion {
    private static final long serialVersionUID = 8416640937812264746L;

    public String globalInfo() {
        return "Turns the bitmask container back into an array of containers for BufferedImage objects, with the image being the first and the bitmasks the other elements.\nThe incoming report gets cloned into all of the outgoing containers.";
    }

    public Class accepts() {
        return BufferedImageBitmaskContainer.class;
    }

    public Class generates() {
        return BufferedImageContainer[].class;
    }

    protected Object doConvert() throws Exception {
        BufferedImageBitmaskContainer input = (BufferedImageBitmaskContainer)this.m_Input;
        BufferedImage[] bitmasks = input.getBitmasks();
        BufferedImageContainer[] result = new BufferedImageContainer[1 + input.getNumBitmasks()];
        result[0] = new BufferedImageContainer();
        result[0].setImage((Object)((BufferedImage)input.getImage()));
        result[0].setReport(input.getReport().getClone());
        for (int i = 0; i < input.getNumBitmasks(); ++i) {
            result[i + 1] = new BufferedImageContainer();
            result[i + 1].setImage((Object)bitmasks[i]);
            result[i + 1].setReport(input.getReport().getClone());
        }
        return result;
    }
}

