/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.image.BufferedImageBitmaskContainer;
import adams.data.image.BufferedImageContainer;
import java.awt.image.BufferedImage;

public class BufferedImagesToBufferedImageBitmaskContainer
extends AbstractConversion {
    private static final long serialVersionUID = 2072620446932941644L;

    public String globalInfo() {
        return "Turns the BufferedImage containers into a container with image (index=0) and bitmasks (index>=1).\nOnly the report from the first container is transferred.";
    }

    public Class accepts() {
        return BufferedImageContainer[].class;
    }

    public Class generates() {
        return BufferedImageBitmaskContainer.class;
    }

    protected Object doConvert() throws Exception {
        BufferedImageContainer[] conts = (BufferedImageContainer[])this.m_Input;
        if (conts.length < 2) {
            throw new IllegalStateException("Expected array of length >=2 of " + Utils.classToString(BufferedImageContainer.class) + " objects, but received: " + conts.length);
        }
        BufferedImageBitmaskContainer result = new BufferedImageBitmaskContainer();
        result.setContent((Object)((BufferedImage)conts[0].getContent()));
        result.setReport(conts[0].getReport().getClone());
        BufferedImage[] bitmasks = new BufferedImage[conts.length - 1];
        for (int i = 1; i < conts.length; ++i) {
            bitmasks[i - 1] = (BufferedImage)conts[i].getImage();
        }
        result.setBitmasks(bitmasks);
        return result;
    }
}

