/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.awt.image.BufferedImage;

public class ImageContainerToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -2365914378679923351L;
    protected boolean m_RemoveAlphaChannel;

    public String globalInfo() {
        return "Turns the image of an image container into a spreadsheet for viewing the pixel values.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remove-alpha-channel", "removeAlphaChannel", (Object)false);
    }

    public void setRemoveAlphaChannel(boolean value) {
        this.m_RemoveAlphaChannel = value;
        this.reset();
    }

    public boolean getRemoveAlphaChannel() {
        return this.m_RemoveAlphaChannel;
    }

    public String removeAlphaChannelTipText() {
        return "If enabled, the alpha channel gets removed from the pixel value.";
    }

    public Class accepts() {
        return AbstractImageContainer.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_Input;
        int[][] matrix = BufferedImageHelper.getPixelRaster((BufferedImage)cont.toBufferedImage());
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < cont.getWidth(); ++i) {
            row.addCell("" + i).setContentAsString("" + (i + 1));
        }
        for (int n = 0; n < matrix.length; ++n) {
            row = result.addRow();
            for (i = 0; i < matrix[n].length; ++i) {
                if (this.m_RemoveAlphaChannel) {
                    row.addCell("" + i).setContent(Integer.valueOf(matrix[n][i] & 0xFFFFFF));
                    continue;
                }
                row.addCell("" + i).setContent(Integer.valueOf(matrix[n][i]));
            }
        }
        return result;
    }
}

