/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.image.moments.MomentHelper;
import adams.data.report.DataType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class OrientationVector
extends AbstractBufferedImageFeatureGenerator {
    protected Color m_BackgroundValue;

    public Color getBackgroundValue() {
        return this.m_BackgroundValue;
    }

    public void setBackgroundValue(Color m_Background) {
        this.m_BackgroundValue = m_Background;
        this.reset();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background-value", "backgroundValue", (Object)Color.WHITE);
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Orientation X", DataType.NUMERIC);
        result.add("Orientation Y", DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        result[0].addAll(MomentHelper.orientationVector((boolean[][])this.imageToMatrix(img)));
        return result;
    }

    public String globalInfo() {
        return null;
    }

    public boolean[][] imageToMatrix(BufferedImageContainer img) {
        BufferedImage image = img.toBufferedImage();
        int bg = this.m_BackgroundValue.getRGB();
        boolean[][] result = new boolean[image.getHeight()][image.getWidth()];
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                result[y][x] = image.getRGB(x, y) != bg;
            }
        }
        return result;
    }
}

