/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Pixels
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected PixelType m_PixelType;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pixel-type", "pixelType", (Object)PixelType.RGB_SINGLE);
    }

    public void setPixelType(PixelType value) {
        this.m_PixelType = value;
        this.reset();
    }

    public PixelType getPixelType() {
        return this.m_PixelType;
    }

    public String pixelTypeTipText() {
        return "The pixel type to use.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        int numPixels = img.getWidth() * img.getHeight();
        HeaderDefinition result = new HeaderDefinition();
        block5: for (int i = 0; i < numPixels; ++i) {
            switch (this.m_PixelType) {
                case RGB_SINGLE: 
                case LUMINANCE_STANDARD: 
                case LUMINANCE_PERCEIVED1: 
                case LUMINANCE_PERCEIVED2: {
                    result.add("att_" + (i + 1), DataType.NUMERIC);
                    continue block5;
                }
                case RGB_SEPARATE: {
                    result.add("att_r_" + (i + 1), DataType.NUMERIC);
                    result.add("att_g_" + (i + 1), DataType.NUMERIC);
                    result.add("att_b_" + (i + 1), DataType.NUMERIC);
                    continue block5;
                }
                case HSB_SEPARATE: {
                    result.add("att_h_" + (i + 1), DataType.NUMERIC);
                    result.add("att_s_" + (i + 1), DataType.NUMERIC);
                    result.add("att_b_" + (i + 1), DataType.NUMERIC);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unhandled pixel type: " + (Object)((Object)this.m_PixelType));
                }
            }
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        switch (this.m_PixelType) {
            case RGB_SINGLE: {
                if (((BufferedImage)img.getImage()).getType() == 10) {
                    int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                    for (int i = 0; i < rgbas.length; ++i) {
                        result[0].add(rgbas[i][0]);
                    }
                } else {
                    int[] pixels = BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)img.getImage()));
                    for (int i = 0; i < pixels.length; ++i) {
                        result[0].add(pixels[i]);
                    }
                }
                break;
            }
            case RGB_SEPARATE: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    result[0].add(rgbas[i][0]);
                    result[0].add(rgbas[i][1]);
                    result[0].add(rgbas[i][2]);
                }
                break;
            }
            case HSB_SEPARATE: {
                float[] hsb = new float[3];
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    hsb = Color.RGBtoHSB(rgbas[i][0], rgbas[i][1], rgbas[i][2], hsb);
                    result[0].add(Float.valueOf(hsb[0]));
                    result[0].add(Float.valueOf(hsb[1]));
                    result[0].add(Float.valueOf(hsb[2]));
                }
                break;
            }
            case LUMINANCE_STANDARD: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    result[0].add((double)rgbas[i][0] * 0.2126 + (double)rgbas[i][1] * 0.7152 + (double)rgbas[i][2] * 0.0722);
                }
                break;
            }
            case LUMINANCE_PERCEIVED1: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    result[0].add((double)rgbas[i][0] * 0.299 + (double)rgbas[i][1] * 0.587 + (double)rgbas[i][2] * 0.114);
                }
                break;
            }
            case LUMINANCE_PERCEIVED2: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    result[0].add(Math.sqrt((double)(rgbas[i][0] * rgbas[i][0]) * 0.241 + (double)(rgbas[i][1] * rgbas[i][1]) * 0.691 + (double)(rgbas[i][2] * rgbas[i][2]) * 0.068));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled pixel type: " + (Object)((Object)this.m_PixelType));
            }
        }
        return result;
    }

    public static enum PixelType {
        RGB_SINGLE,
        RGB_SEPARATE,
        HSB_SEPARATE,
        LUMINANCE_STANDARD,
        LUMINANCE_PERCEIVED1,
        LUMINANCE_PERCEIVED2;

    }
}

