/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.imagesegmentationcontainer;

import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.flow.container.ImageSegmentationContainer;

public abstract class AbstractImageSegmentationContainerOperation
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 1185449853784824033L;

    public String getQuickInfo() {
        return null;
    }

    public abstract int minNumContainersRequired();

    public abstract int maxNumContainersRequired();

    public abstract Class generates();

    protected boolean checkSameDimensions(ImageSegmentationContainer cont1, ImageSegmentationContainer cont2) {
        return cont1.getBaseImage().getWidth() == cont2.getBaseImage().getWidth() && cont1.getBaseImage().getHeight() == cont2.getBaseImage().getHeight();
    }

    protected String checkSameDimensions(ImageSegmentationContainer[] containers) {
        for (int i = 1; i < containers.length; ++i) {
            if (this.checkSameDimensions(containers[0], containers[i])) continue;
            return "All images need to have the same dimensions: " + containers[0].getBaseImage().getWidth() + "x" + containers[0].getBaseImage().getHeight() + " (#1) != " + containers[i].getBaseImage().getWidth() + "x" + containers[i].getBaseImage().getHeight() + "(#" + (i + 1) + ")";
        }
        return null;
    }

    protected void check(ImageSegmentationContainer[] containers) {
        if (containers == null || containers.length == 0) {
            throw new IllegalStateException("No containers provided!");
        }
        if (this.minNumContainersRequired() > 0 && containers.length < this.minNumContainersRequired()) {
            throw new IllegalStateException("Not enough containers supplied (min > supplied): " + this.minNumContainersRequired() + " > " + containers.length);
        }
        if (this.maxNumContainersRequired() > 0 && containers.length > this.maxNumContainersRequired()) {
            throw new IllegalStateException("Too many containers supplied (max < supplied): " + this.maxNumContainersRequired() + " < " + containers.length);
        }
    }

    protected abstract Object doProcess(ImageSegmentationContainer[] var1);

    public Object process(ImageSegmentationContainer[] containers) {
        this.check(containers);
        return this.doProcess(containers);
    }
}

