/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.imagesegmentationcontainer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageHelper;
import adams.data.image.imagesegmentationcontainer.AbstractImageSegmentationContainerOperation;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.ImageSegmentationContainer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConfusionMatrix
extends AbstractImageSegmentationContainerOperation {
    private static final long serialVersionUID = 5451678654384977453L;
    protected BaseString[] m_Labels;
    protected String m_ActualPrefix;
    protected String m_PredictedPrefix;
    protected MatrixValues m_MatrixValues;

    public String globalInfo() {
        return "Evaluates a prediction (first container) against the annotation (second container) and outputs a spreadsheet with the confusion matrix.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("actual-prefix", "actualPrefix", (Object)"a: ");
        this.m_OptionManager.add("predicted-prefix", "predictedPrefix", (Object)"p: ");
        this.m_OptionManager.add("matrix-values", "matrixValues", (Object)MatrixValues.COUNTS);
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to use for enforcing order other than alphabetical.";
    }

    public void setActualPrefix(String value) {
        this.m_ActualPrefix = value;
        this.reset();
    }

    public String getActualPrefix() {
        return this.m_ActualPrefix;
    }

    public String actualPrefixTipText() {
        return "The prefix for the actual labels.";
    }

    public void setPredictedPrefix(String value) {
        this.m_PredictedPrefix = value;
        this.reset();
    }

    public String getPredictedPrefix() {
        return this.m_PredictedPrefix;
    }

    public String predictedPrefixTipText() {
        return "The prefix for the predicted labels.";
    }

    public void setMatrixValues(MatrixValues value) {
        this.m_MatrixValues = value;
        this.reset();
    }

    public MatrixValues getMatrixValues() {
        return this.m_MatrixValues;
    }

    public String matrixValuesTipText() {
        return "The type of values to generate.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"labels", (Object)this.m_Labels, (String)"labels: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"matrixValues", (Object)((Object)this.m_MatrixValues), (String)", values: ");
        return result;
    }

    @Override
    public int minNumContainersRequired() {
        return 2;
    }

    @Override
    public int maxNumContainersRequired() {
        return 2;
    }

    @Override
    public Class generates() {
        return SpreadSheet.class;
    }

    protected void collapse(Map<String, BufferedImage> layers, List<String> labels, int[] collapsed) {
        int black = Color.BLACK.getRGB();
        for (int labelIndex = 0; labelIndex < labels.size(); ++labelIndex) {
            String labelStr = labels.get(labelIndex);
            if (!layers.containsKey(labelStr)) continue;
            int[] pixels = BufferedImageHelper.getPixels((BufferedImage)layers.get(labelStr));
            for (int i = 0; i < pixels.length; ++i) {
                if (pixels[i] == black) continue;
                collapsed[i] = labelIndex + 1;
            }
        }
    }

    protected Object convert(double value) {
        if (this.m_MatrixValues == MatrixValues.COUNTS) {
            return (int)value;
        }
        return value;
    }

    @Override
    protected Object doProcess(ImageSegmentationContainer[] containers) {
        int n;
        int i;
        ArrayList<Object> labels;
        ImageSegmentationContainer predCont = containers[0];
        Map predLayers = (Map)predCont.getValue("layers");
        ImageSegmentationContainer annoCont = containers[1];
        Map annoLayers = (Map)annoCont.getValue("layers");
        if (this.m_Labels.length > 0) {
            labels = new ArrayList<String>(Arrays.asList(BaseObject.toStringArray((BaseObject[])this.m_Labels)));
        } else {
            labels = new ArrayList(annoLayers.keySet());
            Collections.sort(labels);
        }
        int length = 0;
        Iterator iterator = labels.iterator();
        if (iterator.hasNext()) {
            String label = (String)iterator.next();
            length = ((BufferedImage)predLayers.get(label)).getWidth() * ((BufferedImage)predLayers.get(label)).getHeight();
        }
        if (length == 0) {
            return new DefaultSpreadSheet();
        }
        int[] annotations = new int[length];
        this.collapse(annoLayers, labels, annotations);
        int[] predictions = new int[length];
        this.collapse(predLayers, labels, predictions);
        double[][] matrix = new double[labels.size() + 1][labels.size() + 1];
        for (i = 0; i < annotations.length; ++i) {
            double[] dArray = matrix[annotations[i]];
            int n2 = predictions[i];
            dArray[n2] = dArray[n2] + 1.0;
        }
        switch (this.m_MatrixValues) {
            case COUNTS: {
                break;
            }
            case PERCENTAGES_PER_ROW: {
                double total;
                for (n = 0; n < labels.size() + 1; ++n) {
                    total = 0.0;
                    for (i = 0; i < labels.size() + 1; ++i) {
                        total += matrix[n][i];
                    }
                    i = 0;
                    while (i < labels.size() + 1) {
                        double[] dArray = matrix[n];
                        int n3 = i++;
                        dArray[n3] = dArray[n3] / total;
                    }
                }
                break;
            }
            case PERCENTAGES: {
                double total = 0.0;
                for (n = 0; n < labels.size() + 1; ++n) {
                    for (i = 0; i < labels.size() + 1; ++i) {
                        total += matrix[n][i];
                    }
                }
                for (n = 0; n < labels.size() + 1; ++n) {
                    i = 0;
                    while (i < labels.size() + 1) {
                        double[] dArray = matrix[n];
                        int n4 = i++;
                        dArray[n4] = dArray[n4] / total;
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled matrix values type: " + (Object)((Object)this.m_MatrixValues));
            }
        }
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("L").setContentAsString("x");
        row.addCell("U").setContentAsString(this.m_PredictedPrefix + "Unlabeled");
        for (i = 0; i < labels.size(); ++i) {
            row.addCell("" + i).setContentAsString(this.m_PredictedPrefix + (String)labels.get(i));
        }
        row = result.addRow();
        row.addCell("L").setContentAsString(this.m_ActualPrefix + "Unlabeled");
        row.addCell("U").setNative(this.convert(matrix[0][0]));
        for (i = 0; i < labels.size(); ++i) {
            row.addCell("" + i).setNative(this.convert(matrix[0][i + 1]));
        }
        for (n = 0; n < labels.size(); ++n) {
            row = result.addRow();
            row.addCell("L").setContentAsString(this.m_ActualPrefix + (String)labels.get(n));
            row.addCell("U").setNative(this.convert(matrix[n + 1][0]));
            for (i = 0; i < labels.size(); ++i) {
                row.addCell("" + i).setNative(this.convert(matrix[n + 1][i + 1]));
            }
        }
        return result;
    }

    public static enum MatrixValues {
        COUNTS,
        PERCENTAGES,
        PERCENTAGES_PER_ROW;

    }
}

