/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.imagesegmentationcontainer;

import adams.data.image.BufferedImageHelper;
import adams.data.image.imagesegmentationcontainer.AbstractImageSegmentationContainerOperation;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.ImageSegmentationContainer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CountPixels
extends AbstractImageSegmentationContainerOperation {
    private static final long serialVersionUID = 5451678654384977453L;

    public String globalInfo() {
        return "Counts the pixels and generates a spreadsheet with count per layer.";
    }

    @Override
    public int minNumContainersRequired() {
        return 1;
    }

    @Override
    public int maxNumContainersRequired() {
        return 1;
    }

    @Override
    public Class generates() {
        return SpreadSheet.class;
    }

    protected int count(int[] pixels) {
        int black = Color.BLACK.getRGB();
        int result = 0;
        for (int i = 0; i < pixels.length; ++i) {
            if (pixels[i] == black) continue;
            ++result;
        }
        return result;
    }

    @Override
    protected Object doProcess(ImageSegmentationContainer[] containers) {
        ImageSegmentationContainer cont = containers[0];
        Map layers = (Map)cont.getValue("layers");
        ArrayList labels = new ArrayList(layers.keySet());
        Collections.sort(labels);
        HashMap<String, int[]> pixels = new HashMap<String, int[]>();
        for (String label : labels) {
            if (!layers.containsKey(label)) continue;
            pixels.put(label, BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)layers.get(label))));
        }
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.addComment("Name: " + cont.getValue("name"));
        HeaderRow row = result.getHeaderRow();
        row.addCell("L").setContentAsString("Layer");
        row.addCell("C").setContentAsString("Count");
        for (String label : labels) {
            row = result.addRow();
            row.getCell("L").setContentAsString(label);
            row.getCell("C").setContent(Integer.valueOf(this.count((int[])pixels.get(label))));
        }
        return result;
    }
}

