/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.multiimageoperation;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import java.awt.image.BufferedImage;

public class ApplyMask
extends AbstractBufferedImageMultiImageOperation {
    private static final long serialVersionUID = 3811234791768694013L;

    public String globalInfo() {
        return "Uses the second image as mask that gets applied to the first image.\nPixels from the first image are only kept if the corresponding ones in the mask are non-zero.";
    }

    @Override
    public int minNumImagesRequired() {
        return 2;
    }

    @Override
    public int maxNumImagesRequired() {
        return 2;
    }

    protected void check(BufferedImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = this.checkSameDimensions((AbstractImageContainer[])images);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected BufferedImageContainer[] doProcess(BufferedImageContainer[] images) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage img = (BufferedImage)images[0].getImage();
        BufferedImage mask = (BufferedImage)images[1].getImage();
        BufferedImage output = BufferedImageHelper.deepCopy((BufferedImage)img);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int m = mask.getRGB(x, y) & 0xFFFFFF;
                if (m != 0) continue;
                output.setRGB(x, y, 0);
            }
        }
        result[0] = new BufferedImageContainer();
        result[0].setImage((Object)output);
        return result;
    }
}

