/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.multiimageoperation;

import adams.core.ClassCrossReference;
import adams.core.Utils;
import adams.data.image.BufferedImageContainer;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import adams.data.image.transformer.subimages.Grid;
import adams.data.objectfilter.Translate;
import adams.flow.transformer.DeleteOverlappingImageObjects;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class MergeGrid
extends AbstractBufferedImageMultiImageOperation
implements ClassCrossReference {
    private static final long serialVersionUID = 1888786897723421704L;
    protected String m_Prefix;
    protected int m_NumCols;
    protected int m_NumRows;
    protected int m_OverlapX;
    protected int m_OverlapY;

    public String globalInfo() {
        return "Merges a grid of sub-images into a single image, including the annotations.\nOpposite operation to " + Utils.classToString(Grid.class) + ".\nExpects the image array to represent the cells in the grid in a row-wise fashion.\nOnly combines object annotations from reports, other field values will be discarded.\nDoes not remove overlapping objects, see " + Utils.classToString(DeleteOverlappingImageObjects.class) + ".";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{Grid.class, DeleteOverlappingImageObjects.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("num-cols", "numCols", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)1, (Number)1, null);
        this.m_OptionManager.add("overlap-x", "overlapX", (Object)0, (Number)0, null);
        this.m_OptionManager.add("overlap-y", "overlapY", (Object)0, (Number)0, null);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setNumCols(int value) {
        if (this.getOptionManager().isValid("numCols", (Number)value)) {
            this.m_NumCols = value;
            this.reset();
        }
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public String numColsTipText() {
        return "The number of columns.";
    }

    public void setNumRows(int value) {
        if (this.getOptionManager().isValid("numRows", (Number)value)) {
            this.m_NumRows = value;
            this.reset();
        }
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of rows.";
    }

    public void setOverlapX(int value) {
        if (this.getOptionManager().isValid("overlapX", (Number)value)) {
            this.m_OverlapX = value;
            this.reset();
        }
    }

    public int getOverlapX() {
        return this.m_OverlapX;
    }

    public String overlapXTipText() {
        return "The overlap on the x axis.";
    }

    public void setOverlapY(int value) {
        if (this.getOptionManager().isValid("overlapY", (Number)value)) {
            this.m_OverlapY = value;
            this.reset();
        }
    }

    public int getOverlapY() {
        return this.m_OverlapY;
    }

    public String overlapYTipText() {
        return "The overlap on the y axis.";
    }

    @Override
    public int minNumImagesRequired() {
        return this.m_NumCols * this.m_NumRows;
    }

    @Override
    public int maxNumImagesRequired() {
        return this.m_NumCols * this.m_NumRows;
    }

    protected Dimension determineDimensions(BufferedImageContainer[] images) {
        int i;
        int width = 0;
        int height = 0;
        for (i = 0; i < this.m_NumCols; ++i) {
            width += images[i].getWidth();
            if (i <= 0) continue;
            width -= this.m_OverlapX;
        }
        for (i = 0; i < this.m_NumRows; i += this.m_NumCols) {
            height += images[i].getHeight();
            if (i <= 0) continue;
            height -= this.m_OverlapY;
        }
        return new Dimension(width, height);
    }

    protected int calcOffset(BufferedImageContainer[] images, int index, boolean calcX) {
        int result = 0;
        int x = index % this.m_NumCols;
        int y = index / this.m_NumCols;
        if (calcX) {
            for (int i = 0; i < x; ++i) {
                result += images[i].getWidth();
                result -= this.m_OverlapX;
            }
        } else {
            for (int i = 0; i < y; ++i) {
                result += images[i * this.m_NumCols].getHeight();
                result -= this.m_OverlapY;
            }
        }
        return result;
    }

    protected BufferedImageContainer[] doProcess(BufferedImageContainer[] images) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        Dimension dims = this.determineDimensions(images);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Output dimensions: width=" + dims.width + ", height=" + dims.height);
        }
        BufferedImage newImg = new BufferedImage(dims.width, dims.height, 2);
        result[0] = (BufferedImageContainer)images[0].getHeader();
        result[0].setImage((Object)newImg);
        LocatedObjects all = new LocatedObjects();
        for (int i = 0; i < images.length; ++i) {
            int x = this.calcOffset(images, i, true);
            int y = this.calcOffset(images, i, false);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Image #" + (i + 1) + ": x=" + x + ", y=" + y);
            }
            BufferedImage img = (BufferedImage)images[i].getImage();
            int[] pixels = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
            newImg.setRGB(x, y, img.getWidth(), img.getHeight(), pixels, 0, img.getWidth());
            LocatedObjects objs = LocatedObjects.fromReport(images[i].getReport(), this.m_Prefix);
            if (x > 0 || y > 0) {
                Translate trans = new Translate();
                trans.setX(x);
                trans.setY(y);
                objs = trans.filter(objs);
            }
            all.addAll(objs);
        }
        result[0].getReport().mergeWith(all.toReport(this.m_Prefix));
        return result;
    }
}

