/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.gui.core.ColorHelper;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import gnu.trove.map.hash.TIntIntHashMap;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class BlueChannelColorizer
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 4183676541160281269L;
    protected ColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Interprets the values in the blue channel (e.g., used by image segmentation frameworks) of the images as indices and replaces them with colors from the specified color provider.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)this.getDefaultColorProvider());
    }

    protected ColorProvider getDefaultColorProvider() {
        return new DefaultColorProvider();
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for the blue channel indices.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int i;
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        BufferedImage oldImg = (BufferedImage)img.getContent();
        int[] oldPixels = BufferedImageHelper.getPixels((BufferedImage)oldImg);
        int max = 0;
        for (i = 0; i < oldPixels.length; ++i) {
            oldPixels[i] = oldPixels[i] & 0xFF;
            max = Math.max(oldPixels[i], max);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("# max index: " + max);
        }
        this.m_ColorProvider.resetColors();
        TIntIntHashMap map = new TIntIntHashMap();
        for (i = 0; i <= max; ++i) {
            map.put(i, this.m_ColorProvider.next().getRGB());
            Field field = new Field("Color-" + i, DataType.STRING);
            result[0].getReport().addField((AbstractField)field);
            result[0].getReport().setValue((AbstractField)field, (Object)ColorHelper.toHex((Color)new Color(map.get(i))));
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("color map: " + map);
        }
        int[] newPixels = new int[oldPixels.length];
        for (i = 0; i < oldPixels.length; ++i) {
            newPixels[i] = map.get(oldPixels[i]);
        }
        BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        newImg.setRGB(0, 0, img.getWidth(), img.getHeight(), newPixels, 0, img.getWidth());
        result[0].setContent((Object)newImg);
        return result;
    }
}

