/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.CustomColorProvider;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class GrayOrIndexedColorizer
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 4183676541160281269L;
    protected boolean m_ForceGrayScale;
    protected ColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Colorizes grayscale or indexed images using the specified color provider.\nOther images types get converted to grayscale first.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("force-gray-scale", "forceGrayScale", (Object)false);
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)this.getDefaultColorProvider());
    }

    public void setForceGrayScale(boolean value) {
        this.m_ForceGrayScale = value;
        this.reset();
    }

    public boolean getForceGrayScale() {
        return this.m_ForceGrayScale;
    }

    public String forceGrayScaleTipText() {
        return "If enabled, the image is forced into grayscale first (if not binary/indexed/grayscale), otherwise it is used as is.";
    }

    protected ColorProvider getDefaultColorProvider() {
        CustomColorProvider result = new CustomColorProvider();
        result.setColors(new Color[]{Color.YELLOW, Color.BLUE, Color.RED});
        return result;
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for coloring in the grayscale/indexed image.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"forceGrayScale", (boolean)this.m_ForceGrayScale, (String)"gray-scale");
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImage oldImg;
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        if (this.m_ForceGrayScale) {
            int type = ((BufferedImage)img.getContent()).getType();
            switch (type) {
                case 10: 
                case 12: 
                case 13: {
                    oldImg = (BufferedImage)img.getContent();
                    break;
                }
                default: {
                    oldImg = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getContent()), (int)10);
                    break;
                }
            }
        } else {
            oldImg = (BufferedImage)img.getContent();
        }
        int[] oldPixels = BufferedImageHelper.getPixels((BufferedImage)oldImg);
        TIntHashSet unique = new TIntHashSet(oldPixels);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("# unique colors: " + unique.size());
        }
        this.m_ColorProvider.resetColors();
        int[] colors = unique.toArray();
        Arrays.sort(colors);
        TIntIntHashMap map = new TIntIntHashMap();
        for (int color : colors) {
            map.put(color, this.m_ColorProvider.next().getRGB());
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("color map: " + map);
        }
        int[] newPixels = new int[oldPixels.length];
        for (int i = 0; i < oldPixels.length; ++i) {
            newPixels[i] = map.get(oldPixels[i]);
        }
        BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        newImg.setRGB(0, 0, img.getWidth(), img.getHeight(), newPixels, 0, img.getWidth());
        result[0].setContent((Object)newImg);
        return result;
    }
}

