/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.luminance.AbstractLuminanceParameters;
import adams.data.image.luminance.BT601;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;

public class Grayscale
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 8400999643470579756L;
    protected AbstractLuminanceParameters m_Luminance;

    public String globalInfo() {
        return "Generates a grayscale images using the specified luminance parameters.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("luminance", "luminance", (Object)new BT601());
    }

    public void setLuminance(AbstractLuminanceParameters value) {
        this.m_Luminance = value;
        this.reset();
    }

    public AbstractLuminanceParameters getLuminance() {
        return this.m_Luminance;
    }

    public String luminanceTipText() {
        return "Supplies the luminance parameters for the grayscale conversion.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"luminance", (Object)((Object)this.m_Luminance), (String)"luminance: ");
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        double[] luminance = this.m_Luminance.getParameters();
        BufferedImage orig = img.toBufferedImage();
        BufferedImage gray = new BufferedImage(orig.getWidth(), orig.getHeight(), 1);
        result[0].setImage((Object)gray);
        for (int x = 0; x < orig.getWidth(); ++x) {
            for (int y = 0; y < orig.getHeight(); ++y) {
                int rgbOrig = orig.getRGB(x, y);
                int rgbGray = (int)((double)((rgbOrig & 0xFF0000) >>> 16) * luminance[0] + (double)((rgbOrig & 0xFF00) >>> 8) * luminance[1] + (double)(rgbOrig & 0xFF) * luminance[2]);
                gray.setRGB(x, y, (rgbGray << 16) + (rgbGray << 8) + rgbGray);
            }
        }
        return result;
    }
}

