/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiTransformer
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 7793661256600883689L;
    protected AbstractBufferedImageTransformer[] m_Transformers;

    public String globalInfo() {
        return "Applies the specified JAI transformers one after the other.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformers", (Object)new AbstractBufferedImageTransformer[0]);
    }

    public void setTransformers(AbstractBufferedImageTransformer[] value) {
        this.m_Transformers = value;
        this.reset();
    }

    public AbstractBufferedImageTransformer[] getTransformers() {
        return this.m_Transformers;
    }

    public String transformersTipText() {
        return "The transformers to apply one after the other.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        ArrayList<BufferedImageContainer> result = new ArrayList<BufferedImageContainer>();
        result.add(img);
        ArrayList<BufferedImageContainer> input = new ArrayList<BufferedImageContainer>();
        for (int i = 0; i < this.m_Transformers.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Transformer #" + (i + 1) + "...");
            }
            input.clear();
            input.addAll(result);
            result.clear();
            for (BufferedImageContainer cont : input) {
                result.addAll(Arrays.asList((BufferedImageContainer[])this.m_Transformers[i].transform((AbstractImageContainer)cont)));
            }
        }
        return result.toArray(new BufferedImageContainer[result.size()]);
    }
}

