/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ObjectAnnotationsMask
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = -7828174332731436229L;
    protected ObjectFinder m_Finder;

    public String globalInfo() {
        return "Only leaves pixels in the image that are covered by the object annotations (= masking).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder);
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImage imageOld = (BufferedImage)img.getContent();
        LocatedObjects objects = this.m_Finder.findObjects(img.getReport());
        BufferedImage mask = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        Graphics2D g2d = mask.createGraphics();
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2d.setColor(Color.WHITE);
        for (LocatedObject obj : objects) {
            if (obj.hasPolygon()) {
                g2d.fillPolygon(obj.getPolygon());
                continue;
            }
            g2d.fillRect(obj.getX(), obj.getY(), obj.getWidth(), obj.getHeight());
        }
        g2d.dispose();
        BufferedImage imageNew = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        for (int y = 0; y < mask.getHeight(); ++y) {
            for (int x = 0; x < mask.getWidth(); ++x) {
                int m = mask.getRGB(x, y) & 0xFFFFFF;
                if (m == 0) {
                    imageNew.setRGB(x, y, 0);
                    continue;
                }
                imageNew.setRGB(x, y, imageOld.getRGB(x, y));
            }
        }
        BufferedImageContainer[] result = new BufferedImageContainer[]{new BufferedImageContainer()};
        result[0].setReport(img.getReport().getClone());
        result[0].setImage((Object)imageNew);
        return result;
    }
}

