/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.base.BaseColor;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.statistics.StatUtils;
import gnu.trove.map.TIntIntMap;
import java.awt.image.BufferedImage;

public class ReplacePredominantColor
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = -7828174332731436229L;
    protected BaseColor m_NewColor;

    public String globalInfo() {
        return "Allows replacing the predominant color with another.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("new-color", "newColor", (Object)new BaseColor());
    }

    public void setNewColor(BaseColor value) {
        this.m_NewColor = value;
        this.reset();
    }

    public BaseColor getNewColor() {
        return this.m_NewColor;
    }

    public String newColorTipText() {
        return "The replacement color.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int newColor;
        TIntIntMap counts = StatUtils.uniqueCounts((int[])BufferedImageHelper.getPixels((BufferedImage)img.toBufferedImage()));
        if (counts.size() == 0) {
            this.getLogger().warning("Failed to determine color counts!");
            return new BufferedImageContainer[]{img};
        }
        int dominantColor = newColor = this.m_NewColor.toColorValue().getRGB();
        int dominantCount = 0;
        for (int color : counts.keys()) {
            int count = counts.get(color);
            if (count <= dominantCount) continue;
            dominantColor = color;
            dominantCount = count;
        }
        if (dominantCount == 0) {
            this.getLogger().warning("Failed to determine color counts!");
            return new BufferedImageContainer[]{img};
        }
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getClone()};
        int[] pixels = ((BufferedImage)result[0].getImage()).getRGB(0, 0, ((BufferedImage)result[0].getImage()).getWidth(), ((BufferedImage)result[0].getImage()).getHeight(), null, 0, ((BufferedImage)result[0].getImage()).getWidth());
        for (int i = 0; i < pixels.length; ++i) {
            if (pixels[i] != dominantColor) continue;
            pixels[i] = newColor;
        }
        ((BufferedImage)result[0].getImage()).setRGB(0, 0, ((BufferedImage)result[0].getImage()).getWidth(), ((BufferedImage)result[0].getImage()).getHeight(), pixels, 0, ((BufferedImage)result[0].getImage()).getWidth());
        return result;
    }
}

