/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.subimages;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.subimages.AbstractSubImagesGenerator;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Grid
extends AbstractSubImagesGenerator {
    private static final long serialVersionUID = 2488185528644078539L;
    public static final String KEY_COLUMN = "Column";
    public static final String KEY_ROW = "Row";
    public static final String KEY_OVERLAP_X = "OverlapX";
    public static final String KEY_OVERLAP_Y = "OverlapY";
    protected int m_NumCols;
    protected int m_NumRows;
    protected int m_OverlapX;
    protected int m_OverlapY;

    public String globalInfo() {
        return "Splits the image using a grid of specified number of columns and rows.\nAdditional report values:\n- Row for the row\n- Column for the column\nIt is possible to generate overlapping images (all but last row and last column) by defining overlaps. In case of overlaps, the following report values are then available:\n- OverlapX on the x axis\n- OverlapY on the y axis";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-cols", "numCols", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)1, (Number)1, null);
        this.m_OptionManager.add("overlap-x", "overlapX", (Object)0, (Number)0, null);
        this.m_OptionManager.add("overlap-y", "overlapY", (Object)0, (Number)0, null);
    }

    public void setNumCols(int value) {
        if (this.getOptionManager().isValid("numCols", (Number)value)) {
            this.m_NumCols = value;
            this.reset();
        }
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public String numColsTipText() {
        return "The number of columns.";
    }

    public void setNumRows(int value) {
        if (this.getOptionManager().isValid("numRows", (Number)value)) {
            this.m_NumRows = value;
            this.reset();
        }
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of rows.";
    }

    public void setOverlapX(int value) {
        if (this.getOptionManager().isValid("overlapX", (Number)value)) {
            this.m_OverlapX = value;
            this.reset();
        }
    }

    public int getOverlapX() {
        return this.m_OverlapX;
    }

    public String overlapXTipText() {
        return "The overlap on the x axis.";
    }

    public void setOverlapY(int value) {
        if (this.getOptionManager().isValid("overlapY", (Number)value)) {
            this.m_OverlapY = value;
            this.reset();
        }
    }

    public int getOverlapY() {
        return this.m_OverlapY;
    }

    public String overlapYTipText() {
        return "The overlap on the y axis.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numCols", (Object)this.m_NumCols, (String)", cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numRows", (Object)this.m_NumRows, (String)", rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlapX", (Object)this.m_OverlapX, (String)", overlap x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlapY", (Object)this.m_OverlapY, (String)", overlap y: ");
        return result;
    }

    @Override
    protected List<BufferedImageContainer> doProcess(BufferedImageContainer image) {
        ArrayList<BufferedImageContainer> result = new ArrayList<BufferedImageContainer>();
        BufferedImage bimage = (BufferedImage)image.getImage();
        int dw = bimage.getWidth() / this.m_NumCols;
        int dh = bimage.getHeight() / this.m_NumRows;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("height=" + bimage.getHeight() + ", width=" + bimage.getWidth() + ", dh=" + dh + ", dw=" + dw);
        }
        for (int w = 0; w < this.m_NumCols; ++w) {
            int width;
            int overlapX;
            int x = w * dw;
            if (w == this.m_NumCols - 1) {
                overlapX = 0;
                width = bimage.getWidth() - x;
            } else {
                overlapX = this.m_OverlapX;
                if (x + dw - 1 + overlapX >= bimage.getWidth()) {
                    overlapX = bimage.getWidth() - (x + dw - 1);
                }
                width = dw + overlapX;
            }
            for (int h = 0; h < this.m_NumRows; ++h) {
                int height;
                int overlapY;
                int y = h * dh;
                if (h == this.m_NumRows - 1) {
                    overlapY = 0;
                    height = bimage.getHeight() - y;
                } else {
                    overlapY = this.m_OverlapY;
                    if (y + dh - 1 + overlapY >= bimage.getHeight()) {
                        overlapY = bimage.getHeight() - (y + dh - 1);
                    }
                    height = dh + overlapY;
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("row=" + h + ", col=" + w + ", x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + ", overlapX=" + overlapX + ", overlapY=" + overlapY);
                }
                BufferedImageContainer cont = (BufferedImageContainer)image.getHeader();
                cont.setReport(this.transferObjects(cont.getReport(), x, y, width, height));
                cont.setImage((Object)bimage.getSubimage(x, y, width, height));
                cont.getReport().setNumericValue(KEY_COLUMN, (double)w);
                cont.getReport().setNumericValue(KEY_ROW, (double)h);
                if (this.m_OverlapX != 0 || this.m_OverlapY != 0) {
                    cont.getReport().setNumericValue(KEY_OVERLAP_X, (double)overlapX);
                    cont.getReport().setNumericValue(KEY_OVERLAP_Y, (double)overlapY);
                }
                result.add(cont);
            }
        }
        return result;
    }
}

