/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.FileUtils;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class CocoAnnotationsReportReader
extends AbstractReportReader<Report>
implements ObjectPrefixHandler {
    private static final long serialVersionUID = 5716807404370681434L;
    protected String m_Prefix;
    protected String m_LabelKey;

    public String globalInfo() {
        return "Loads COCO annotations from the JSON file, with one report per image.\nHandles only segmentations with polygons (not RLE) and only one polygon per annotation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("label-key", "labelKey", (Object)"type");
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The key in the meta-data containing the label, ignored if empty.";
    }

    public String getFormatDescription() {
        return "Detectron Annotations JSON";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    protected Map<Integer, String> loadCategories(JSONArray categories) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (categories != null) {
            for (int i = 0; i < categories.size(); ++i) {
                JSONObject category = (JSONObject)categories.get(i);
                result.put(category.getAsNumber("id").intValue(), category.getAsString("name"));
            }
        }
        return result;
    }

    protected void addValue(Report report, String key, Object value) {
        Field field = value instanceof Number ? new Field(key, DataType.NUMERIC) : (value instanceof Boolean ? new Field(key, DataType.BOOLEAN) : (value instanceof String ? new Field(key, DataType.STRING) : new Field(key, DataType.UNKNOWN)));
        if (value instanceof String && ((String)value).isEmpty()) {
            return;
        }
        report.addField((AbstractField)field);
        report.setValue((AbstractField)field, value);
    }

    protected Map<Integer, Report> loadImages(JSONArray images) {
        HashMap<Integer, Report> result = new HashMap<Integer, Report>();
        if (images != null) {
            for (int i = 0; i < images.size(); ++i) {
                JSONObject image = (JSONObject)images.get(i);
                Report report = new Report();
                this.addValue(report, "Width", image.getAsNumber("width").intValue());
                this.addValue(report, "Height", image.getAsNumber("height").intValue());
                this.addValue(report, "Filename", image.getAsString("file_name"));
                this.addValue(report, "Date captured", image.getAsString("date_captured"));
                result.put(image.getAsNumber("id").intValue(), report);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(this.m_Input.getAbsolutePath());
            breader = new BufferedReader(freader);
            JSONParser parser = new JSONParser(1984);
            JSONObject obj = (JSONObject)parser.parse((Reader)breader);
            Map<Integer, String> categories = this.loadCategories((JSONArray)obj.get((Object)"categories"));
            Map<Integer, Report> images = this.loadImages((JSONArray)obj.get((Object)"images"));
            JSONArray annotationsArray = (JSONArray)obj.get((Object)"annotations");
            HashMap<Integer, LocatedObjects> annotations = new HashMap<Integer, LocatedObjects>();
            if (annotationsArray != null) {
                for (int i = 0; i < annotationsArray.size(); ++i) {
                    JSONArray poly;
                    JSONObject region = (JSONObject)annotationsArray.get(i);
                    int imageID = region.getAsNumber("image_id").intValue();
                    int labelID = region.getAsNumber("category_id").intValue();
                    JSONArray bbox = (JSONArray)region.get((Object)"bbox");
                    double x = (Double)bbox.get(0);
                    double y = (Double)bbox.get(1);
                    double width = (Double)bbox.get(2);
                    double height = (Double)bbox.get(3);
                    LocatedObject object = new LocatedObject((int)x, (int)y, (int)width, (int)height);
                    if (!annotations.containsKey(imageID)) {
                        annotations.put(imageID, new LocatedObjects());
                    }
                    ((LocatedObjects)annotations.get(imageID)).add(object);
                    if (categories.containsKey(labelID)) {
                        object.getMetaData().put(this.m_LabelKey, categories.get(labelID));
                    }
                    if (!region.containsKey((Object)"segmentation") || !region.containsKey((Object)"iscrowd") || region.getAsNumber("iscrowd").intValue() != 0 || (poly = (JSONArray)region.get((Object)"segmentation")).size() < 1) continue;
                    poly = (JSONArray)poly.get(0);
                    TIntArrayList polyX = new TIntArrayList();
                    TIntArrayList polyY = new TIntArrayList();
                    for (int n = 0; n < poly.size(); n += 2) {
                        polyX.add(((Double)poly.get(n)).intValue());
                        polyY.add(((Double)poly.get(n + 1)).intValue());
                    }
                    object.setPolygon(new Polygon(polyX.toArray(), polyY.toArray(), polyX.size()));
                }
            }
            for (Integer id : images.keySet()) {
                if (!annotations.containsKey(id)) continue;
                images.get(id).mergeWith(((LocatedObjects)annotations.get(id)).toReport(this.m_Prefix));
            }
            ArrayList<Integer> ids = new ArrayList<Integer>(images.keySet());
            Collections.sort(ids);
            for (Integer id : ids) {
                result.add(images.get(id));
            }
        }
        catch (Exception e) {
            try {
                this.getLogger().log(Level.SEVERE, "Failed to read JSON file: " + this.m_Input, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly(freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }
}

