/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.report.Report;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DeepLabCutCSVReader
extends AbstractReportReader<Report> {
    private static final long serialVersionUID = 5868402740072822596L;
    public static final String KEY_FILENAME = "Filename";
    public static final String KEY_INDIVIDUALS = "Individuals";
    public static final String KEY_LABELS = "Labels";
    protected String m_Prefix;
    protected BaseRegExp m_FileRegExp;

    public String globalInfo() {
        return "Reads point annotations into multiple reports from DeepLabCut's CSV format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Point.");
        this.m_OptionManager.add("file-regexp", "fileRegExp", (Object)new BaseRegExp(".*"));
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setFileRegExp(BaseRegExp value) {
        this.m_FileRegExp = value;
        this.reset();
    }

    public BaseRegExp getFileRegExp() {
        return this.m_FileRegExp;
    }

    public String fileRegExpTipText() {
        return "The regular expression that the file names must match in order to be turned into reports.";
    }

    public String getFormatDescription() {
        return "DeepLabCut CSV";
    }

    public String[] getFormatExtensions() {
        return new String[]{"csv"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    protected List<Report> readData() {
        int i;
        ArrayList<Report> result = new ArrayList<Report>();
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setParseFormulas(false);
        SpreadSheet sheet = reader.read((File)this.m_Input);
        if (sheet.getRowCount() < 3) {
            this.getLogger().warning("Not enough rows in spreadsheet?");
            return result;
        }
        boolean multi = sheet.getRowCount() > 0 && sheet.getCell(0, 0).getContent().equals("individuals");
        HashMap<Integer, String> labels = new HashMap<Integer, String>();
        ArrayList<String> uniqueLabels = new ArrayList<String>();
        if (sheet.getRowCount() > 1) {
            for (i = 1; i < sheet.getColumnCount(); ++i) {
                String label = multi ? sheet.getRow(1).getCell(i).getContent() : sheet.getRow(0).getCell(i).getContent();
                labels.put(i, label);
                if (uniqueLabels.contains(label)) continue;
                uniqueLabels.add(label);
            }
        }
        HashMap<Integer, String> individuals = new HashMap<Integer, String>();
        ArrayList<String> uniqueIndividuals = new ArrayList<String>();
        if (multi) {
            DataRow indRow = sheet.getRow(0);
            for (i = 1; i < indRow.getCellCount(); ++i) {
                String individual = indRow.getCell(i).getContent();
                individuals.put(i, individual);
                if (uniqueIndividuals.contains(individual)) continue;
                uniqueIndividuals.add(individual);
            }
        }
        if (multi) {
            sheet.removeRow(0);
        }
        sheet.removeRow(0);
        sheet.removeRow(0);
        HashMap<String, Report> reports = new HashMap<String, Report>();
        for (Row row : sheet.rows()) {
            Report report;
            String file = row.getCell(0).getContent();
            if (!this.m_FileRegExp.isMatchAll() && !this.m_FileRegExp.isMatch(file)) continue;
            if (!reports.containsKey(file)) {
                report = new Report();
                report.setStringValue(KEY_FILENAME, file);
                report.setStringValue(KEY_INDIVIDUALS, Utils.flatten(uniqueIndividuals, (String)","));
                report.setStringValue(KEY_LABELS, Utils.flatten(uniqueLabels, (String)","));
                reports.put(file, report);
            }
            report = (Report)reports.get(file);
            int col = 0;
            for (i = 1; i < row.getCellCount(); i += 2) {
                ++col;
                if (!row.hasCell(i) || row.getCell(i).isMissing()) continue;
                double x = row.getCell(i).toDouble();
                double y = row.getCell(i + 1).toDouble();
                report.setNumericValue(this.m_Prefix + Utils.padLeft((String)("" + col), (char)'0', (int)4) + ".x", x);
                report.setNumericValue(this.m_Prefix + Utils.padLeft((String)("" + col), (char)'0', (int)4) + ".y", y);
                report.setStringValue(this.m_Prefix + Utils.padLeft((String)("" + col), (char)'0', (int)4) + ".type", (String)labels.get(i));
                if (!multi) continue;
                report.setStringValue(this.m_Prefix + Utils.padLeft((String)("" + col), (char)'0', (int)4) + ".individual", (String)individuals.get(i));
            }
        }
        ArrayList files = new ArrayList(reports.keySet());
        Collections.sort(files);
        for (String f : files) {
            result.add((Report)reports.get(f));
        }
        return result;
    }
}

