/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageSegmentationAnnotationReader;
import adams.data.io.input.ImageSegmentationAnnotationReaderWithLayerNames;
import adams.data.io.output.ImageSegmentationAnnotationWriter;
import adams.data.io.output.IndexedPNGImageSegmentationWriter;
import adams.flow.container.ImageSegmentationContainer;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageLineByte;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngReader;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class IndexedPNGImageSegmentationReader
extends AbstractImageSegmentationAnnotationReader
implements ImageSegmentationAnnotationReaderWithLayerNames {
    private static final long serialVersionUID = -5567473437385041915L;
    protected boolean m_SkipFirstLayer;
    protected BaseString[] m_LayerNames;

    public String globalInfo() {
        return "The first palette index of the PNG is assumed to be the background, for the remainder the supplied layer names are used.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("skip-first-layer", "skipFirstLayer", (Object)true);
        this.m_OptionManager.add("layer-name", "layerNames", (Object)new BaseString[0]);
    }

    public void setSkipFirstLayer(boolean value) {
        this.m_SkipFirstLayer = value;
        this.reset();
    }

    public boolean getSkipFirstLayer() {
        return this.m_SkipFirstLayer;
    }

    public String skipFirstLayerTipText() {
        return "If enabled, the first layer gets skipped (usually the background).";
    }

    @Override
    public void setLayerNames(BaseString[] value) {
        this.m_LayerNames = value;
        this.reset();
    }

    @Override
    public BaseString[] getLayerNames() {
        return this.m_LayerNames;
    }

    @Override
    public String layerNamesTipText() {
        return "The names to use for the layers; if additional layers should be present in the data, names get assigned automatically.";
    }

    @Override
    public ImageSegmentationAnnotationWriter getCorrespondingWriter() {
        return new IndexedPNGImageSegmentationWriter();
    }

    public String getFormatDescription() {
        return "Indexed PNG image segmentation";
    }

    public String[] getFormatExtensions() {
        return new String[]{"jpg"};
    }

    public String getDefaultFormatExtension() {
        return "jpg";
    }

    @Override
    protected String check(PlaceholderFile file) {
        PlaceholderFile png;
        String result = super.check(file);
        if (result == null && !(png = FileUtils.replaceExtension((PlaceholderFile)file, (String)".png")).exists()) {
            result = "Associated PNG file with annotations is missing!";
        }
        return result;
    }

    protected Map<String, BufferedImage> readLayers(File file) {
        HashMap<String, BufferedImage> result = new HashMap<String, BufferedImage>();
        try {
            int i;
            int n;
            PngReader reader = new PngReader(file.getAbsoluteFile());
            if (this.isLoggingEnabled()) {
                this.getLogger().info(reader.imgInfo.toString());
            }
            if (!reader.imgInfo.indexed) {
                this.getLogger().severe("PNG is not indexed: " + file);
                return result;
            }
            if (reader.imgInfo.channels != 1) {
                this.getLogger().severe("Expected one channel, but found " + reader.imgInfo.channels + " in: " + file);
                return result;
            }
            int[] pixels = new int[reader.imgInfo.cols * reader.imgInfo.rows];
            int maxIndex = 0;
            for (n = 0; n < reader.imgInfo.rows; ++n) {
                int color;
                IImageLine line = reader.readRow();
                if (line instanceof ImageLineByte) {
                    ImageLineByte lineByte = (ImageLineByte)reader.readRow(n);
                    for (i = 0; i < reader.imgInfo.cols; ++i) {
                        pixels[i + n * reader.imgInfo.cols] = color = lineByte.getElem(i);
                        maxIndex = Math.max(maxIndex, color);
                    }
                    continue;
                }
                ImageLineInt lineInt = (ImageLineInt)reader.readRow(n);
                for (i = 0; i < reader.imgInfo.cols; ++i) {
                    pixels[i + n * reader.imgInfo.cols] = color = lineInt.getElem(i);
                    maxIndex = Math.max(maxIndex, color);
                }
            }
            int black = Color.BLACK.getRGB();
            int white = Color.WHITE.getRGB();
            int idx = 0;
            for (n = 0; n <= maxIndex; ++n) {
                if (this.m_SkipFirstLayer && n == 0) continue;
                int[] layerPixels = new int[pixels.length];
                for (i = 0; i < layerPixels.length; ++i) {
                    layerPixels[i] = pixels[i] == n ? white : black;
                }
                BufferedImage image = new BufferedImage(reader.imgInfo.cols, reader.imgInfo.rows, 1);
                image.setRGB(0, 0, image.getWidth(), image.getHeight(), layerPixels, 0, image.getWidth());
                if (idx >= this.m_LayerNames.length) {
                    result.put("layer-" + (idx + 1), image);
                } else {
                    result.put(this.m_LayerNames[idx].getValue(), image);
                }
                ++idx;
            }
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to read PNG: " + file, (Throwable)e);
        }
        return result;
    }

    @Override
    protected ImageSegmentationContainer doRead(PlaceholderFile file) {
        BufferedImage baseImage = BufferedImageHelper.read((File)file).toBufferedImage();
        PlaceholderFile png = FileUtils.replaceExtension((PlaceholderFile)file, (String)".png");
        Map<String, BufferedImage> layerImages = this.readLayers((File)png);
        ImageSegmentationContainer result = new ImageSegmentationContainer(file.getName(), baseImage, layerImages);
        return result;
    }
}

