/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.lister.LocalDirectoryLister;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.PassThrough;
import adams.data.io.input.AbstractImageSegmentationAnnotationReader;
import adams.data.io.input.PNGImageReader;
import adams.data.io.output.ImageSegmentationAnnotationWriter;
import adams.data.io.output.IndividualImageSegmentationLayerWriter;
import adams.flow.container.ImageSegmentationContainer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;

public class IndividualImageSegmentationLayerReader
extends AbstractImageSegmentationAnnotationReader {
    private static final long serialVersionUID = -7333525229208134545L;
    protected AbstractBufferedImageTransformer m_LayerTransformer;

    public String globalInfo() {
        return "Uses a JPG as base image and indexed PNG files for the individual layers (0 = background, 1 = annotation).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("layer-transformer", "layerTransformer", (Object)new PassThrough());
    }

    public void setLayerTransformer(AbstractBufferedImageTransformer value) {
        this.m_LayerTransformer = value;
        this.reset();
    }

    public AbstractBufferedImageTransformer getLayerTransformer() {
        return this.m_LayerTransformer;
    }

    public String layerTransformerTipText() {
        return "The image transformer to apply to the layer images.";
    }

    public String getFormatDescription() {
        return "Individual image segmentation layers";
    }

    public String[] getFormatExtensions() {
        return new String[]{"jpg", "jpeg"};
    }

    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    @Override
    public ImageSegmentationAnnotationWriter getCorrespondingWriter() {
        return new IndividualImageSegmentationLayerWriter();
    }

    @Override
    protected ImageSegmentationContainer doRead(PlaceholderFile file) {
        BufferedImage base = BufferedImageHelper.read((File)file).toBufferedImage();
        String name = FileUtils.replaceExtension((String)file.getName(), (String)"");
        HashMap<String, BufferedImage> layers = new HashMap<String, BufferedImage>();
        ImageSegmentationContainer result = new ImageSegmentationContainer(name, base, layers);
        LocalDirectoryLister lister = new LocalDirectoryLister();
        lister.setListFiles(true);
        lister.setListDirs(false);
        lister.setRecursive(false);
        lister.setWatchDir(file.getParentFile().getAbsolutePath());
        lister.setRegExp(new BaseRegExp(name + "-.*\\.(png|PNG)"));
        String[] files = lister.list();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Found # layer PNG files: " + files.length);
        }
        if (files.length > 0) {
            PNGImageReader reader = new PNGImageReader();
            for (String f : files) {
                PlaceholderFile phFile;
                BufferedImageContainer cont;
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Reading: " + f);
                }
                if ((cont = (BufferedImageContainer)reader.read(phFile = new PlaceholderFile(f))) == null) {
                    this.getLogger().severe("Failed to read: " + f);
                    continue;
                }
                String layer = FileUtils.replaceExtension((String)phFile.getName(), (String)"").replaceAll(".*-", "");
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Layer name: " + layer);
                }
                if (!(this.m_LayerTransformer instanceof PassThrough)) {
                    BufferedImageContainer[] conts = (BufferedImageContainer[])this.m_LayerTransformer.transform((AbstractImageContainer)cont);
                    if (conts.length != 1) {
                        this.getLogger().warning("Image transformer did not generate just one image, but " + conts.length + " (" + file + ")");
                    }
                    if (conts.length > 0) {
                        cont = conts[0];
                    } else {
                        this.getLogger().warning("Image transformer did not generate any output, falling back to original data (" + file + ")!");
                    }
                }
                layers.put(layer, cont.toBufferedImage());
            }
        }
        return result;
    }
}

