/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.FileUtils;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class OpexObjectLocationsReader
extends AbstractReportReader<Report>
implements ObjectPrefixHandler {
    protected Field m_ID;
    protected Field m_Timestamp;
    protected String m_Prefix;
    protected String m_LabelSuffix;
    protected String m_ScoreSuffix;
    protected String m_MetaPrefix;

    public String globalInfo() {
        return "Reads object locations from JSON generated by the opex library.\n\nSee more:\nhttps://github.com/WaikatoLink2020/objdet-predictions-exchange-format";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", (Object)new Field("ID", DataType.STRING));
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new Field("Timestamp", DataType.STRING));
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("label-suffix", "labelSuffix", (Object)"type");
        this.m_OptionManager.add("score-suffix", "scoreSuffix", (Object)"score");
        this.m_OptionManager.add("meta-prefix", "metaPrefix", (Object)"Meta.");
    }

    public void setID(Field value) {
        this.m_ID = value;
        this.reset();
    }

    public Field getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The field to use for storing the ID.";
    }

    public void setTimestamp(Field value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public Field getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The field to use for storing the timestamp.";
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report for the objects.";
    }

    public void setLabelSuffix(String value) {
        this.m_LabelSuffix = value;
        this.reset();
    }

    public String getLabelSuffix() {
        return this.m_LabelSuffix;
    }

    public String labelSuffixTipText() {
        return "The suffix to use in the report for labels.";
    }

    public void setScoreSuffix(String value) {
        this.m_ScoreSuffix = value;
        this.reset();
    }

    public String getScoreSuffix() {
        return this.m_ScoreSuffix;
    }

    public String scoreSuffixTipText() {
        return "The suffix to use in the report for scores.";
    }

    public void setMetaPrefix(String value) {
        this.m_MetaPrefix = value;
        this.reset();
    }

    public String getMetaPrefix() {
        return this.m_MetaPrefix;
    }

    public String metaPrefixTipText() {
        return "The report field prefix used in the report for the meta-data.";
    }

    public String getFormatDescription() {
        return "Opex annotations";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(this.m_Input.getAbsolutePath());
            breader = new BufferedReader(freader);
            JSONParser parser = new JSONParser(1984);
            JSONObject obj = (JSONObject)parser.parse((Reader)breader);
            Report report = this.newInstance();
            report.addField((AbstractField)this.m_ID);
            report.addField((AbstractField)this.m_Timestamp);
            if (obj.containsKey((Object)"timestamp")) {
                report.setStringValue(this.m_Timestamp.getName(), obj.getAsString("timestamp"));
            }
            if (obj.containsKey((Object)"id")) {
                report.setStringValue(this.m_ID.getName(), obj.getAsString("id"));
            }
            if (obj.containsKey((Object)"meta")) {
                JSONObject meta = (JSONObject)obj.get((Object)"meta");
                for (String key : meta.keySet()) {
                    report.setStringValue(this.m_MetaPrefix + key, "" + meta.get((Object)key));
                }
            }
            LocatedObjects lobjs = new LocatedObjects();
            if (obj.containsKey((Object)"objects")) {
                JSONArray objects = (JSONArray)obj.get((Object)"objects");
                TIntArrayList xPoints = new TIntArrayList();
                TIntArrayList yPoints = new TIntArrayList();
                for (int i = 0; i < objects.size(); ++i) {
                    JSONObject object = (JSONObject)objects.get(i);
                    Double score = null;
                    if (object.containsKey((Object)"score")) {
                        score = object.getAsNumber("score").doubleValue();
                    }
                    String label = null;
                    if (object.containsKey((Object)"label")) {
                        label = object.getAsString("label");
                    }
                    JSONObject bbox = (JSONObject)object.get((Object)"bbox");
                    int left = bbox.getAsNumber("left").intValue();
                    int top = bbox.getAsNumber("top").intValue();
                    int right = bbox.getAsNumber("right").intValue();
                    int bottom = bbox.getAsNumber("bottom").intValue();
                    xPoints.clear();
                    yPoints.clear();
                    JSONArray points = (JSONArray)((JSONObject)object.get((Object)"polygon")).get((Object)"points");
                    for (int n = 0; n < points.size(); ++n) {
                        JSONArray pair = (JSONArray)points.get(n);
                        xPoints.add(((Number)pair.get(0)).intValue());
                        yPoints.add(((Number)pair.get(1)).intValue());
                    }
                    LocatedObject lobj = new LocatedObject(left, top, right - left + 1, bottom - top + 1);
                    lobj.setPolygon(new Polygon(xPoints.toArray(), yPoints.toArray(), xPoints.size()));
                    if (score != null) {
                        lobj.getMetaData().put(this.m_ScoreSuffix, score);
                    }
                    if (label != null) {
                        lobj.getMetaData().put(this.m_LabelSuffix, label);
                    }
                    lobjs.add(lobj);
                }
            }
            report.mergeWith(lobjs.toReport(this.m_Prefix));
            result.add(report);
        }
        catch (Exception e) {
            try {
                this.getLogger().log(Level.SEVERE, "Failed to read JSON file: " + this.m_Input, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly(freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }
}

