/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.conversion.XMLToDOM;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PascalVOCObjectLocationsReader
extends AbstractReportReader<Report>
implements ObjectPrefixHandler {
    protected Field m_ID;
    protected Field m_Timestamp;
    protected String m_Prefix;
    protected String m_LabelSuffix;
    protected String m_MetaPrefix;

    public String globalInfo() {
        return "Reads object locations in Pascal VOC format.\n\nSee more:\nhttps://github.com/WaikatoLink2020/objdet-predictions-exchange-format";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", (Object)new Field("ID", DataType.STRING));
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new Field("Timestamp", DataType.STRING));
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("label-suffix", "labelSuffix", (Object)"type");
        this.m_OptionManager.add("meta-prefix", "metaPrefix", (Object)"Meta.");
    }

    public void setID(Field value) {
        this.m_ID = value;
        this.reset();
    }

    public Field getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The field to use for storing the ID.";
    }

    public void setTimestamp(Field value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public Field getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The field to use for storing the timestamp.";
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report for the objects.";
    }

    public void setLabelSuffix(String value) {
        this.m_LabelSuffix = value;
        this.reset();
    }

    public String getLabelSuffix() {
        return this.m_LabelSuffix;
    }

    public String labelSuffixTipText() {
        return "The suffix to use in the report for labels.";
    }

    public void setMetaPrefix(String value) {
        this.m_MetaPrefix = value;
        this.reset();
    }

    public String getMetaPrefix() {
        return this.m_MetaPrefix;
    }

    public String metaPrefixTipText() {
        return "The report field prefix used in the report for the meta-data.";
    }

    public String getFormatDescription() {
        return "Pascal VOC annotations";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xml"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    protected Element getNode(Document dom, String tag) {
        Element result = null;
        NodeList nodes = dom.getElementsByTagName(tag);
        if (nodes.getLength() > 0 && nodes.item(0) instanceof Element) {
            result = (Element)nodes.item(0);
        }
        return result;
    }

    protected String getNodeText(Document dom, String tag) {
        String result = null;
        Element node = this.getNode(dom, tag);
        if (node != null) {
            result = node.getTextContent();
        }
        return result;
    }

    protected Element getSubNode(Element parent, String tag) {
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            Element sub;
            if (!(parent.getChildNodes().item(i) instanceof Element) || !(sub = (Element)parent.getChildNodes().item(i)).getTagName().equals(tag)) continue;
            return sub;
        }
        return null;
    }

    protected String getSubNodeText(Element parent, String tag) {
        String result = null;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            Element sub;
            if (!(parent.getChildNodes().item(i) instanceof Element) || !(sub = (Element)parent.getChildNodes().item(i)).getTagName().equals(tag)) continue;
            result = sub.getTextContent();
        }
        return result;
    }

    protected boolean addString(Report report, String name, String value) {
        if (value == null) {
            return false;
        }
        Field field = new Field(name, DataType.STRING);
        report.addField((AbstractField)field);
        report.setStringValue(field.getName(), value);
        return true;
    }

    protected boolean addNumeric(Report report, String name, String value) {
        if (value == null) {
            return false;
        }
        Field field = new Field(name, DataType.NUMERIC);
        try {
            report.addField((AbstractField)field);
            report.setNumericValue(field.getName(), Double.parseDouble(value));
            return true;
        }
        catch (Exception e) {
            if (this.isLoggingEnabled()) {
                this.getLogger().warning("Failed to parse numeric value for field '" + name + "': " + value);
            }
            return false;
        }
    }

    protected boolean addBoolean(Report report, String name, Boolean value) {
        if (value == null) {
            return false;
        }
        Field field = new Field(name, DataType.BOOLEAN);
        report.addField((AbstractField)field);
        report.setBooleanValue(field.getName(), value.booleanValue());
        return true;
    }

    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        String xml = Utils.flatten((List)FileUtils.loadFromFile((File)this.m_Input), (String)"\n");
        XMLToDOM conv = new XMLToDOM();
        conv.setInput((Object)xml);
        String msg = conv.convert();
        if (msg == null) {
            LocatedObjects lobjs = new LocatedObjects();
            Document dom = (Document)conv.getOutput();
            String id = this.getNodeText(dom, "filename");
            Element node = this.getNode(dom, "size");
            String height = this.getSubNodeText(node, "height");
            String width = this.getSubNodeText(node, "width");
            String depth = this.getSubNodeText(node, "depth");
            String segmented = this.getNodeText(dom, "segmented");
            NodeList nodes = dom.getElementsByTagName("object");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element bbox;
                if (!(nodes.item(i) instanceof Element) || (bbox = this.getSubNode(node = (Element)nodes.item(i), "bndbox")) == null) continue;
                LocatedObject lobj = null;
                try {
                    int xmin = Integer.parseInt(this.getSubNodeText(bbox, "xmin"));
                    int xmax = Integer.parseInt(this.getSubNodeText(bbox, "xmax"));
                    int ymin = Integer.parseInt(this.getSubNodeText(bbox, "ymin"));
                    int ymax = Integer.parseInt(this.getSubNodeText(bbox, "ymax"));
                    lobj = new LocatedObject(xmin, ymin, xmax - xmin + 1, ymax - ymin + 1);
                    lobjs.add(lobj);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to parse coordinates!", (Throwable)e);
                    continue;
                }
                String value = this.getSubNodeText(node, "name");
                if (value != null) {
                    lobj.getMetaData().put(this.m_LabelSuffix, value);
                }
                if ((value = this.getSubNodeText(node, "pose")) != null) {
                    lobj.getMetaData().put("pose", value);
                }
                if ((value = this.getSubNodeText(node, "truncated")) != null) {
                    lobj.getMetaData().put("truncated", value.equalsIgnoreCase("1"));
                }
                if ((value = this.getSubNodeText(node, "difficult")) != null) {
                    lobj.getMetaData().put("difficult", value.equalsIgnoreCase("1"));
                }
                if ((value = this.getSubNodeText(node, "occluded")) == null) continue;
                lobj.getMetaData().put("occluded", value.equalsIgnoreCase("1"));
            }
            Report report = lobjs.toReport(this.m_Prefix);
            report.setValue((AbstractField)this.m_ID, (Object)id);
            this.addNumeric(report, this.m_MetaPrefix + "width", width);
            this.addNumeric(report, this.m_MetaPrefix + "height", height);
            this.addNumeric(report, this.m_MetaPrefix + "depth", depth);
            this.addBoolean(report, this.m_MetaPrefix + "segmented", segmented.equalsIgnoreCase("1"));
            result.add(report);
        }
        return result;
    }
}

