/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.DeepLabCutCSVReader;
import adams.data.io.output.AbstractMultiReportWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.report.Report;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import java.io.File;
import java.util.HashMap;

public class DeepLabCutCSVWriter
extends AbstractMultiReportWriter<Report>
implements ObjectPrefixHandler {
    private static final long serialVersionUID = -2029708376194967647L;
    protected String m_FilePrefix;
    protected BaseString[] m_Individuals;
    protected BaseString[] m_Labels;
    protected String m_Prefix;

    public String globalInfo() {
        return "Writes point annotations from multiple reports in DeepLabCut's CSV format.\nExpects the filename to be stored in the 'Filename' report field.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file-prefix", "filePrefix", (Object)"");
        this.m_OptionManager.add("individual", "individuals", (Object)new BaseString[0]);
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("prefix", "prefix", (Object)"Point.");
    }

    public void setFilePrefix(String value) {
        this.m_FilePrefix = value;
        this.reset();
    }

    public String getFilePrefix() {
        return this.m_FilePrefix;
    }

    public String filePrefixTipText() {
        return "The file prefix (ie path) used in the output.";
    }

    public void setIndividuals(BaseString[] value) {
        this.m_Individuals = value;
        this.reset();
    }

    public BaseString[] getIndividuals() {
        return this.m_Individuals;
    }

    public String individualsTipText() {
        return "The individuals for multi-animal output, leave empty for single animal output.";
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to output.";
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public String getFormatDescription() {
        return new DeepLabCutCSVReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new DeepLabCutCSVReader().getFormatExtensions();
    }

    public Class getReportClass() {
        return Report.class;
    }

    protected boolean writeData(Report[] data) {
        String key;
        int n;
        int col;
        int i;
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        boolean multi = this.m_Individuals.length > 0;
        int numIndividuals = multi ? this.m_Individuals.length : 1;
        HeaderRow row = sheet.getHeaderRow();
        row.addCell("0").setContentAsString("scorer");
        for (i = 0; i < numIndividuals * this.m_Labels.length * 2; ++i) {
            row.addCell("" + (i + 1)).setContentAsString(System.getProperty("user.name"));
        }
        if (multi) {
            row = sheet.addRow();
            row.addCell(0).setContentAsString("individuals");
            col = 1;
            for (n = 0; n < numIndividuals; ++n) {
                for (i = 0; i < this.m_Labels.length * 2; ++i) {
                    row.addCell(col).setContentAsString(this.m_Individuals[n].getValue());
                    ++col;
                }
            }
        }
        row = sheet.addRow();
        row.addCell(0).setContentAsString("bodyparts");
        col = 1;
        for (n = 0; n < numIndividuals; ++n) {
            for (i = 0; i < this.m_Labels.length; ++i) {
                row.addCell(col).setContentAsString(this.m_Labels[i].getValue());
                row.addCell(++col).setContentAsString(this.m_Labels[i].getValue());
                ++col;
            }
        }
        HashMap<String, Integer> pos = new HashMap<String, Integer>();
        row = sheet.addRow();
        row.addCell(0).setContentAsString("coords");
        col = 1;
        for (n = 0; n < numIndividuals; ++n) {
            for (i = 0; i < this.m_Labels.length; ++i) {
                key = this.m_Labels[i].getValue();
                if (multi) {
                    key = this.m_Individuals[n].getValue() + "-" + key;
                }
                pos.put(key, col);
                row.addCell(col).setContentAsString("x");
                row.addCell(++col).setContentAsString("y");
                ++col;
            }
        }
        for (Report report : data) {
            row = sheet.addRow();
            String file = report.hasValue("Filename") ? report.getStringValue("Filename") : "";
            if (!this.m_FilePrefix.isEmpty()) {
                String filePrefix = FileUtils.useForwardSlashes((String)this.m_FilePrefix);
                if (!filePrefix.endsWith("/")) {
                    filePrefix = filePrefix + "/";
                }
                file = !file.isEmpty() ? filePrefix + new PlaceholderFile(file).getName() : filePrefix;
            }
            row.addCell(0).setContentAsString(file);
            LocatedObjects objs = LocatedObjects.fromReport(report, this.m_Prefix);
            for (LocatedObject obj : objs) {
                key = "" + obj.getMetaData().getOrDefault("type", "");
                if (multi) {
                    key = obj.getMetaData().getOrDefault("individual", "") + "-" + key;
                }
                if (!pos.containsKey(key)) continue;
                row.addCell(((Integer)pos.get(key)).intValue()).setContent(Integer.valueOf(obj.getX()));
                row.addCell((Integer)pos.get(key) + 1).setContent(Integer.valueOf(obj.getY()));
            }
        }
        CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
        writer.setQuoteCharacter("");
        return writer.write((SpreadSheet)sheet, (File)this.m_Output);
    }
}

