/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassCrossReference;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.GrayOrIndexedColorizer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.ApacheCommonsImageWriter;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.CustomColorProvider;
import java.awt.Color;

public class GrayOrIndexedImageWriter
extends AbstractImageWriter<BufferedImageContainer>
implements ClassCrossReference {
    private static final long serialVersionUID = 8155769915641682158L;
    protected ColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Changes the unique colors to the ones specified by the color provider.\nUseful for generating human-viewable images from image segmentation annotations.\nUses " + Utils.classToString(ApacheCommonsImageWriter.class) + " for performing the actual writing after the conversion.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{ApacheCommonsImageWriter.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)this.getDefaultColorProvider());
    }

    protected ColorProvider getDefaultColorProvider() {
        CustomColorProvider result = new CustomColorProvider();
        result.setColors(new Color[]{Color.YELLOW, Color.BLUE, Color.RED});
        return result;
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for coloring in the grayscale/indexed image.";
    }

    public String getFormatDescription() {
        return "Gray/indexed image writer";
    }

    public String[] getFormatExtensions() {
        return new ApacheCommonsImageWriter().getFormatExtensions();
    }

    public AbstractImageReader getCorrespondingReader() {
        return null;
    }

    protected String doWrite(PlaceholderFile file, BufferedImageContainer cont) {
        GrayOrIndexedColorizer colorizer = new GrayOrIndexedColorizer();
        colorizer.setLoggingLevel(this.m_LoggingLevel);
        colorizer.setColorProvider((ColorProvider)this.m_ColorProvider.shallowCopy());
        cont = ((BufferedImageContainer[])colorizer.transform((AbstractImageContainer)cont))[0];
        colorizer.cleanUp();
        return new ApacheCommonsImageWriter().write(file, (AbstractImageContainer)cont);
    }
}

