/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.ImageSegmentationAnnotationReader;
import adams.data.io.input.IndexedPNGImageSegmentationReader;
import adams.data.io.output.AbstractImageSegmentationAnnotationWriter;
import adams.data.io.output.ImageSegmentationAnnotationWriterWithLayerNames;
import adams.flow.container.ImageSegmentationContainer;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Map;

public class IndexedPNGImageSegmentationWriter
extends AbstractImageSegmentationAnnotationWriter
implements ImageSegmentationAnnotationWriterWithLayerNames {
    private static final long serialVersionUID = 3566330074754565825L;
    protected BaseString[] m_LayerNames;
    protected ColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Each layer gets stored with a separate color in the palette.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("layer-name", "layerNames", (Object)new BaseString[0]);
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
    }

    @Override
    public void setLayerNames(BaseString[] value) {
        this.m_LayerNames = value;
        this.reset();
    }

    @Override
    public BaseString[] getLayerNames() {
        return this.m_LayerNames;
    }

    @Override
    public String layerNamesTipText() {
        return "The names to of the layers to output; outputs all if none specified.";
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for the palette.";
    }

    @Override
    public ImageSegmentationAnnotationReader getCorrespondingReader() {
        return new IndexedPNGImageSegmentationReader();
    }

    public String getFormatDescription() {
        return new IndexedPNGImageSegmentationReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new IndexedPNGImageSegmentationReader().getFormatExtensions();
    }

    public String getDefaultFormatExtension() {
        return new IndexedPNGImageSegmentationReader().getDefaultFormatExtension();
    }

    @Override
    protected String check(PlaceholderFile file, ImageSegmentationContainer annotations) {
        Map layers;
        String result = super.check(file, annotations);
        if (result == null && ((layers = (Map)annotations.getValue("layers")) == null || layers.size() == 0)) {
            result = "No layers in container!";
        }
        return result;
    }

    @Override
    protected String doWrite(PlaceholderFile file, ImageSegmentationContainer annotations) {
        Object[] layerNames;
        BufferedImage baseImage = (BufferedImage)annotations.getValue("base");
        Map layers = (Map)annotations.getValue("layers");
        if (this.m_LayerNames.length == 0) {
            layerNames = layers.keySet().toArray(new String[0]);
            Arrays.sort(layerNames);
        } else {
            layerNames = BaseObject.toStringArray((BaseObject[])this.m_LayerNames);
        }
        int[] combPixels = new int[baseImage.getWidth() * baseImage.getHeight()];
        int black = Color.BLACK.getRGB();
        Arrays.fill(combPixels, black);
        this.m_ColorProvider.resetColors();
        for (int i = 0; i < layerNames.length; ++i) {
            int color = this.m_ColorProvider.next().getRGB();
            if (!layers.containsKey(layerNames[i])) continue;
            int[] currPixels = BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)layers.get(layerNames[i])));
            for (int n = 0; n < currPixels.length; ++n) {
                if ((currPixels[n] & 0xFFFFFF) <= 0) continue;
                combPixels[n] = 0xFF000000 | color;
            }
        }
        BufferedImage combImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 1);
        combImage.setRGB(0, 0, combImage.getWidth(), combImage.getHeight(), combPixels, 0, combImage.getWidth());
        combImage = BufferedImageHelper.convert((BufferedImage)combImage, (int)13);
        return BufferedImageHelper.write((BufferedImage)combImage, (File)file);
    }
}

