/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.base.BaseString;
import adams.data.io.output.AbstractReportWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.io.File;
import java.util.Arrays;

public class ObjectLocationsSpreadSheetWriter
extends AbstractReportWriter<Report> {
    private static final long serialVersionUID = -199610824853876294L;
    protected SpreadSheetWriter m_Writer;
    protected ObjectFinder m_Finder;
    protected String m_ColLeft;
    protected String m_ColTop;
    protected String m_ColRight;
    protected String m_ColBottom;
    protected String m_ColWidth;
    protected String m_ColHeight;
    protected String m_ColPolygonX;
    protected String m_ColPolygonY;
    protected String m_ColType;
    protected String m_MetaDataKeyType;
    protected BaseString[] m_MetaDataKeys;
    protected boolean m_OutputNormalized;
    protected int m_Width;
    protected int m_Height;

    public String globalInfo() {
        return null;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new CsvSpreadSheetWriter());
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("col-left", "colLeft", (Object)"");
        this.m_OptionManager.add("col-top", "colTop", (Object)"");
        this.m_OptionManager.add("col-right", "colRight", (Object)"");
        this.m_OptionManager.add("col-bottom", "colBottom", (Object)"");
        this.m_OptionManager.add("col-width", "colWidth", (Object)"");
        this.m_OptionManager.add("col-height", "colHeight", (Object)"");
        this.m_OptionManager.add("col-polygon-x", "colPolygonX", (Object)"");
        this.m_OptionManager.add("col-polygon-y", "colPolygonY", (Object)"");
        this.m_OptionManager.add("col-type", "colType", (Object)"");
        this.m_OptionManager.add("meta-data-key-type", "metaDataKeyType", (Object)"type");
        this.m_OptionManager.add("meta-data-keys", "metaDataKeys", (Object)new BaseString[0]);
        this.m_OptionManager.add("output-normalized", "outputNormalized", (Object)false);
        this.m_OptionManager.add("width", "width", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)1000, (Number)1, null);
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for writing the spreadsheet.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use for selecting a subset of objects before generating the spreadsheet.";
    }

    public void setColLeft(String value) {
        this.m_ColLeft = value;
        this.reset();
    }

    public String getColLeft() {
        return this.m_ColLeft;
    }

    public String colLeftTipText() {
        return "The column containing the left coordinate.";
    }

    public void setColTop(String value) {
        this.m_ColTop = value;
        this.reset();
    }

    public String getColTop() {
        return this.m_ColTop;
    }

    public String colTopTipText() {
        return "The column containing the top coordinate.";
    }

    public void setColRight(String value) {
        this.m_ColRight = value;
        this.reset();
    }

    public String getColRight() {
        return this.m_ColRight;
    }

    public String colRightTipText() {
        return "The column containing the right coordinate.";
    }

    public void setColBottom(String value) {
        this.m_ColBottom = value;
        this.reset();
    }

    public String getColBottom() {
        return this.m_ColBottom;
    }

    public String colBottomTipText() {
        return "The column containing the bottom coordinate.";
    }

    public void setColWidth(String value) {
        this.m_ColWidth = value;
        this.reset();
    }

    public String getColWidth() {
        return this.m_ColWidth;
    }

    public String colWidthTipText() {
        return "The column containing the width coordinate.";
    }

    public void setColHeight(String value) {
        this.m_ColHeight = value;
        this.reset();
    }

    public String getColHeight() {
        return this.m_ColHeight;
    }

    public String colHeightTipText() {
        return "The column containing the height coordinate.";
    }

    public void setColPolygonX(String value) {
        this.m_ColPolygonX = value;
        this.reset();
    }

    public String getColPolygonX() {
        return this.m_ColPolygonX;
    }

    public String colPolygonXTipText() {
        return "The column containing the X coordinates of the polygon (comma-separated list of coordinates); cannot be used without bounding box.";
    }

    public void setColPolygonY(String value) {
        this.m_ColPolygonY = value;
        this.reset();
    }

    public String getColPolygonY() {
        return this.m_ColPolygonY;
    }

    public String colPolygonYTipText() {
        return "The column containing the Y coordinates of the polygon (comma-separated list of coordinates); cannot be used without bounding box.";
    }

    public void setColType(String value) {
        this.m_ColType = value;
        this.reset();
    }

    public String getColType() {
        return this.m_ColType;
    }

    public String colTypeTipText() {
        return "The column containing the object label.";
    }

    public void setMetaDataKeyType(String value) {
        this.m_MetaDataKeyType = value;
        this.reset();
    }

    public String getMetaDataKeyType() {
        return this.m_MetaDataKeyType;
    }

    public String metaDataKeyTypeTipText() {
        return "The meta-data key for the type (= label).";
    }

    public void setOutputNormalized(boolean value) {
        this.m_OutputNormalized = value;
        this.reset();
    }

    public boolean getOutputNormalized() {
        return this.m_OutputNormalized;
    }

    public String outputNormalizedTipText() {
        return "If enabled, normalized coordinates/dimensions (0-1) are output as well with a 'n' suffix in the column name.";
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the image to use when reading normalized coordinates/dimensions.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the image to use when reading normalized coordinates/dimensions.";
    }

    public void setMetaDataKeys(BaseString[] value) {
        this.m_MetaDataKeys = value;
        this.reset();
    }

    public BaseString[] getMetaDataKeys() {
        return this.m_MetaDataKeys;
    }

    public String metaDataKeysTipText() {
        return "The keys of the meta-data values to output as well (keys are used as column names).";
    }

    public String getFormatDescription() {
        return "Object locations";
    }

    public String[] getFormatExtensions() {
        return new String[]{"*"};
    }

    protected double normalizeX(int x) {
        return (double)x / (double)this.m_Width;
    }

    protected double[] normalizeX(int[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (double)x[i] / (double)this.m_Width;
        }
        return result;
    }

    protected double normalizeY(int y) {
        return (double)y / (double)this.m_Height;
    }

    protected double[] normalizeY(int[] y) {
        double[] result = new double[y.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (double)y[i] / (double)this.m_Height;
        }
        return result;
    }

    protected boolean writeData(Report data) {
        int i;
        LocatedObjects objects = this.m_Finder.findObjects(data);
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        HeaderRow row = sheet.getHeaderRow();
        int colLeft = -1;
        int colTop = -1;
        int colRight = -1;
        int colBottom = -1;
        int colWidth = -1;
        int colHeight = -1;
        int colPolygonX = -1;
        int colPolygonY = -1;
        int colType = -1;
        int colLeftN = -1;
        int colTopN = -1;
        int colRightN = -1;
        int colBottomN = -1;
        int colWidthN = -1;
        int colHeightN = -1;
        int colPolygonXN = -1;
        int colPolygonYN = -1;
        int[] metaData = new int[this.m_MetaDataKeys.length];
        Arrays.fill(metaData, -1);
        if (!this.m_ColLeft.trim().isEmpty()) {
            colLeft = row.getCellCount();
            row.addCell("L").setContentAsString(this.m_ColLeft);
        }
        if (!this.m_ColTop.trim().isEmpty()) {
            colTop = row.getCellCount();
            row.addCell("T").setContentAsString(this.m_ColTop);
        }
        if (!this.m_ColRight.trim().isEmpty()) {
            colRight = row.getCellCount();
            row.addCell("R").setContentAsString(this.m_ColRight);
        }
        if (!this.m_ColBottom.trim().isEmpty()) {
            colBottom = row.getCellCount();
            row.addCell("B").setContentAsString(this.m_ColBottom);
        }
        if (!this.m_ColWidth.trim().isEmpty()) {
            colWidth = row.getCellCount();
            row.addCell("W").setContentAsString(this.m_ColWidth);
        }
        if (!this.m_ColHeight.trim().isEmpty()) {
            colHeight = row.getCellCount();
            row.addCell("H").setContentAsString(this.m_ColHeight);
        }
        if (!this.m_ColPolygonX.trim().isEmpty()) {
            colPolygonX = row.getCellCount();
            row.addCell("PX").setContentAsString(this.m_ColPolygonX);
        }
        if (!this.m_ColPolygonY.trim().isEmpty()) {
            colPolygonY = row.getCellCount();
            row.addCell("PY").setContentAsString(this.m_ColPolygonY);
        }
        if (!this.m_ColType.trim().isEmpty()) {
            colType = row.getCellCount();
            row.addCell("TYPE").setContentAsString(this.m_ColType);
        }
        for (i = 0; i < this.m_MetaDataKeys.length; ++i) {
            metaData[i] = row.getCellCount();
            row.addCell("MD-" + i).setContentAsString(this.m_MetaDataKeys[i].getValue());
        }
        if (this.m_OutputNormalized) {
            if (!this.m_ColLeft.trim().isEmpty()) {
                colLeftN = row.getCellCount();
                row.addCell("LN").setContentAsString(this.m_ColLeft + "n");
            }
            if (!this.m_ColTop.trim().isEmpty()) {
                colTopN = row.getCellCount();
                row.addCell("TN").setContentAsString(this.m_ColTop + "n");
            }
            if (!this.m_ColRight.trim().isEmpty()) {
                colRightN = row.getCellCount();
                row.addCell("RN").setContentAsString(this.m_ColRight + "n");
            }
            if (!this.m_ColBottom.trim().isEmpty()) {
                colBottomN = row.getCellCount();
                row.addCell("BN").setContentAsString(this.m_ColBottom + "n");
            }
            if (!this.m_ColWidth.trim().isEmpty()) {
                colWidthN = row.getCellCount();
                row.addCell("WN").setContentAsString(this.m_ColWidth + "n");
            }
            if (!this.m_ColHeight.trim().isEmpty()) {
                colHeightN = row.getCellCount();
                row.addCell("HN").setContentAsString(this.m_ColHeight + "n");
            }
            if (!this.m_ColPolygonX.trim().isEmpty()) {
                colPolygonXN = row.getCellCount();
                row.addCell("PXN").setContentAsString(this.m_ColPolygonX + "n");
            }
            if (!this.m_ColPolygonY.trim().isEmpty()) {
                colPolygonYN = row.getCellCount();
                row.addCell("PYN").setContentAsString(this.m_ColPolygonY + "n");
            }
        }
        for (LocatedObject object : objects) {
            row = sheet.addRow();
            if (colLeft > -1) {
                row.addCell("L").setContent(Integer.valueOf(object.getX()));
            }
            if (colTop > -1) {
                row.addCell("T").setContent(Integer.valueOf(object.getY()));
            }
            if (colRight > -1) {
                row.addCell("R").setContent(Integer.valueOf(object.getX() + object.getWidth() - 1));
            }
            if (colBottom > -1) {
                row.addCell("B").setContent(Integer.valueOf(object.getY() + object.getHeight() - 1));
            }
            if (colWidth > -1) {
                row.addCell("W").setContent(Integer.valueOf(object.getWidth()));
            }
            if (colHeight > -1) {
                row.addCell("H").setContent(Integer.valueOf(object.getHeight()));
            }
            if (object.hasPolygon()) {
                if (colPolygonX > -1) {
                    row.addCell("PX").setContentAsString(Utils.flatten((Object[])StatUtils.toNumberArray((int[])object.getPolygonX()), (String)","));
                }
                if (colPolygonY > -1) {
                    row.addCell("PY").setContentAsString(Utils.flatten((Object[])StatUtils.toNumberArray((int[])object.getPolygonY()), (String)","));
                }
            }
            if (colType > -1 && object.getMetaData().containsKey(this.m_MetaDataKeyType)) {
                row.addCell("TYPE").setContentAsString("" + object.getMetaData().get(this.m_MetaDataKeyType));
            }
            for (i = 0; i < metaData.length; ++i) {
                if (!object.getMetaData().containsKey(this.m_MetaDataKeys[i].getValue())) continue;
                Object value = object.getMetaData().get(this.m_MetaDataKeys[i].getValue());
                if (value instanceof String) {
                    row.addCell("MD-" + i).setContentAsString((String)value);
                    continue;
                }
                row.addCell("MD-" + i).setContent("" + value);
            }
            if (!this.m_OutputNormalized) continue;
            if (colLeftN > -1) {
                row.addCell("LN").setContent(Double.valueOf(this.normalizeX(object.getX())));
            }
            if (colTopN > -1) {
                row.addCell("TN").setContent(Double.valueOf(this.normalizeY(object.getY())));
            }
            if (colRightN > -1) {
                row.addCell("RN").setContent(Double.valueOf(this.normalizeX(object.getX() + object.getWidth() - 1)));
            }
            if (colBottomN > -1) {
                row.addCell("BN").setContent(Double.valueOf(this.normalizeY(object.getY() + object.getHeight() - 1)));
            }
            if (colWidthN > -1) {
                row.addCell("WN").setContent(Double.valueOf(this.normalizeX(object.getWidth())));
            }
            if (colHeightN > -1) {
                row.addCell("HN").setContent(Double.valueOf(this.normalizeY(object.getHeight())));
            }
            if (!object.hasPolygon()) continue;
            if (colPolygonXN > -1) {
                row.addCell("PXN").setContentAsString(Utils.flatten((Object[])StatUtils.toNumberArray((double[])this.normalizeX(object.getPolygonX())), (String)","));
            }
            if (colPolygonYN <= -1) continue;
            row.addCell("PYN").setContentAsString(Utils.flatten((Object[])StatUtils.toNumberArray((double[])this.normalizeY(object.getPolygonY())), (String)","));
        }
        return this.m_Writer.write((SpreadSheet)sheet, (File)this.m_Output);
    }
}

