/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.io.FileUtils;
import adams.core.io.PrettyPrintingSupporter;
import adams.data.io.input.OpexObjectLocationsReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.json.JsonHelper;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.Date;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class OpexObjectLocationsWriter
extends AbstractReportWriter<Report>
implements PrettyPrintingSupporter {
    protected ObjectFinder m_Finder;
    protected Field m_Timestamp;
    protected Field m_ID;
    protected String m_LabelKey;
    protected String m_ScoreKey;
    protected String m_MetaPrefix;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Writes polygon annotations in VGG Image Annotator JSON format.\nFor more information, see:\nhttp://www.robots.ox.ac.uk/~vgg/software/via/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("id", "ID", (Object)new Field("ID", DataType.STRING));
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new Field("Timestamp", DataType.STRING));
        this.m_OptionManager.add("label-key", "labelKey", (Object)"type");
        this.m_OptionManager.add("score-key", "scoreKey", (Object)"score");
        this.m_OptionManager.add("meta-prefix", "metaPrefix", (Object)"Meta.");
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setID(Field value) {
        this.m_ID = value;
        this.reset();
    }

    public Field getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The field to use for storing the ID.";
    }

    public void setTimestamp(Field value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public Field getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The field to use for storing the timestamp.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The key in the meta-data containing the label, ignored if empty.";
    }

    public void setScoreKey(String value) {
        this.m_ScoreKey = value;
        this.reset();
    }

    public String getScoreKey() {
        return this.m_ScoreKey;
    }

    public String scoreKeyTipText() {
        return "The key in the meta-data containing the sore, ignored if empty.";
    }

    public void setMetaPrefix(String value) {
        this.m_MetaPrefix = value;
        this.reset();
    }

    public String getMetaPrefix() {
        return this.m_MetaPrefix;
    }

    public String metaPrefixTipText() {
        return "The report field prefix used in the report for the meta-data.";
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the output is printed in a 'pretty' format.";
    }

    public String getFormatDescription() {
        return new OpexObjectLocationsReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new OpexObjectLocationsReader().getFormatExtensions();
    }

    protected boolean writeData(Report data) {
        DateFormat dformat = DateUtils.getTimestampFormatterMsecs();
        JSONObject all = new JSONObject();
        if (data.hasField((AbstractField)this.m_ID)) {
            all.put((Object)"id", (Object)("" + data.getValue((AbstractField)this.m_ID)));
        } else {
            all.put((Object)"id", (Object)dformat.format(new Date()));
        }
        if (data.hasField((AbstractField)this.m_Timestamp)) {
            all.put((Object)"timestamp", (Object)("" + data.getValue((AbstractField)this.m_Timestamp)));
        }
        JSONObject meta = new JSONObject();
        for (AbstractField field : data.getFields()) {
            if (!field.getName().startsWith(this.m_MetaPrefix)) continue;
            meta.put((Object)field.getName().substring(this.m_MetaPrefix.length()), (Object)("" + data.getValue(field)));
        }
        if (meta.size() > 0) {
            all.put((Object)"meta", (Object)meta);
        }
        LocatedObjects objs = this.m_Finder.findObjects(data);
        JSONArray objects = new JSONArray();
        for (LocatedObject obj : objs) {
            int[] y;
            int[] x;
            JSONObject object = new JSONObject();
            objects.add((Object)object);
            if (!this.m_LabelKey.isEmpty() && obj.getMetaData().containsKey(this.m_LabelKey)) {
                object.put((Object)"label", (Object)("" + obj.getMetaData().get(this.m_LabelKey)));
            } else {
                object.put((Object)"label", (Object)"-no-label-");
            }
            if (!this.m_ScoreKey.isEmpty() && obj.getMetaData().containsKey(this.m_ScoreKey)) {
                object.put((Object)"score", obj.getMetaData().get(this.m_ScoreKey));
            }
            JSONObject bbox = new JSONObject();
            bbox.put((Object)"left", (Object)obj.getX());
            bbox.put((Object)"top", (Object)obj.getY());
            bbox.put((Object)"right", (Object)(obj.getX() + obj.getWidth() - 1));
            bbox.put((Object)"bottom", (Object)(obj.getY() + obj.getHeight() - 1));
            object.put((Object)"bbox", (Object)bbox);
            JSONObject polygon = new JSONObject();
            JSONArray points = new JSONArray();
            if (obj.hasPolygon()) {
                x = obj.getPolygonX();
                y = obj.getPolygonY();
            } else {
                x = new int[]{obj.getX(), obj.getX() + obj.getWidth() - 1, obj.getX() + obj.getWidth() - 1, obj.getX()};
                y = new int[]{obj.getY(), obj.getY(), obj.getY() + obj.getHeight() - 1, obj.getY() + obj.getHeight() - 1};
            }
            for (int n = 0; n < x.length; ++n) {
                JSONArray point = new JSONArray();
                point.add((Object)x[n]);
                point.add((Object)y[n]);
                points.add((Object)point);
            }
            polygon.put((Object)"points", (Object)points);
            object.put((Object)"polygon", (Object)polygon);
        }
        all.put((Object)"objects", (Object)objects);
        String content = this.m_PrettyPrinting ? JsonHelper.prettyPrint((String)all.toString()) : all.toString();
        return FileUtils.writeToFile((String)this.m_Output.getAbsolutePath(), (Object)content, (boolean)false);
    }
}

