/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.FlipDirection;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.operator.TransposeType;

public class Flip
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected FlipDirection m_Direction;

    public String globalInfo() {
        return "Flips an image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("direction", "direction", (Object)FlipDirection.HORIZONTAL);
    }

    public void setDirection(FlipDirection value) {
        this.m_Direction = value;
        this.reset();
    }

    public FlipDirection getDirection() {
        return this.m_Direction;
    }

    public String directionTipText() {
        return "The flip direction.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        TransposeType desc = this.m_Direction == FlipDirection.HORIZONTAL ? TransposeDescriptor.FLIP_HORIZONTAL : TransposeDescriptor.FLIP_VERTICAL;
        BufferedImage inverted = JAI.create((String)"transpose", (RenderedImage)img.toBufferedImage(), (Object)desc).getAsBufferedImage();
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        result[0].setImage((Object)inverted);
        return result;
    }
}

