/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class MakeSquare
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;
    protected SideType m_SideType;

    public String globalInfo() {
        return "Generates a square bounding box around the current center of the bounding box.\nDiscards any polygon data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("side-type", "sideType", (Object)SideType.SMALLER);
    }

    public void setSideType(SideType value) {
        this.m_SideType = value;
        this.reset();
    }

    public SideType getSideType() {
        return this.m_SideType;
    }

    public String sideTypeTipText() {
        return "The type of side of the current bounding box to use for the square box.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"sideType", (Object)((Object)this.m_SideType), (String)"side: ");
        return result;
    }

    protected LocatedObject transform(LocatedObject object, double scaleX, double scaleY, int transX, int transY) {
        LocatedObject result = new LocatedObject(object.getX() + transX, object.getY() + transY, (int)((double)object.getWidth() * scaleX), (int)((double)object.getHeight() * scaleY));
        result.getMetaData().putAll(object.getMetaData());
        result.getMetaData().remove("poly_x");
        result.getMetaData().remove("poly_y");
        if (this.isLoggingEnabled()) {
            this.getLogger().info(object + " -> " + result);
        }
        return result;
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject obj : objects) {
            int transY;
            int transX;
            double scaleY;
            double scaleX;
            int w = obj.getWidth();
            int h = obj.getHeight();
            SideType type = this.m_SideType;
            switch (this.m_SideType) {
                case SMALLER: {
                    if (w < h) {
                        type = SideType.WIDTH;
                        break;
                    }
                    type = SideType.HEIGHT;
                    break;
                }
                case LARGER: {
                    type = w > h ? SideType.WIDTH : SideType.HEIGHT;
                }
            }
            switch (type) {
                case WIDTH: {
                    scaleX = 1.0;
                    scaleY = (double)w / (double)h;
                    transX = 0;
                    transY = -(w - h) / 2;
                    break;
                }
                case HEIGHT: {
                    scaleX = (double)h / (double)w;
                    scaleY = 1.0;
                    transX = -(h - w) / 2;
                    transY = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled side type: " + (Object)((Object)this.m_SideType));
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("w=" + w + ", h=" + h + " -> scaleX=" + scaleX + ", scaleY=" + scaleY + ", transX=" + transX + ", transY=" + transY);
            }
            result.add(this.transform(obj, scaleX, scaleY, transX, transY));
        }
        return result;
    }

    public static enum SideType {
        SMALLER,
        LARGER,
        WIDTH,
        HEIGHT;

    }
}

