/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseKeyValuePair;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.HashMap;
import java.util.Map;

public class RenameLabels
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;
    protected String m_Key;
    protected BaseKeyValuePair[] m_Rules;
    protected transient Map<String, String> m_Lookup;

    public String globalInfo() {
        return "For renaming labels in the meta-data, stored under a specific key.\nThe rules for renaming are specified: old=new.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"type");
        this.m_OptionManager.add("rule", "rules", (Object)new BaseKeyValuePair[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Lookup = null;
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key in the meta-data containing the label.";
    }

    public void setRules(BaseKeyValuePair[] value) {
        this.m_Rules = value;
        this.reset();
    }

    public BaseKeyValuePair[] getRules() {
        return this.m_Rules;
    }

    public String rulesTipText() {
        return "The renaming rules for the labels (old=new pairs).";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)"key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"rules", (Object)this.m_Rules, (String)", rules: ");
        return result;
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        if (this.m_Lookup == null) {
            this.m_Lookup = new HashMap<String, String>();
            for (BaseKeyValuePair rule : this.m_Rules) {
                this.m_Lookup.put(rule.getPairKey(), rule.getPairValue());
            }
        }
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject obj : objects) {
            String old;
            LocatedObject newObj = obj.getClone();
            if (newObj.getMetaData().containsKey(this.m_Key) && this.m_Lookup.containsKey(old = "" + newObj.getMetaData().get(this.m_Key))) {
                newObj.getMetaData().put(this.m_Key, this.m_Lookup.get(old));
            }
            result.add(newObj);
        }
        return result;
    }
}

