/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class TransformMetaData
extends AbstractObjectFilter {
    private static final long serialVersionUID = 5647107073729835067L;
    protected String m_Key;
    protected CallableActorReference m_Transformer;
    protected CallableActorHelper m_Helper;
    protected Actor m_CallableActor;

    public String globalInfo() {
        return "Transforms the specified meta-data using the referenced callable actor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"");
        this.m_OptionManager.add("transformer", "transformer", (Object)new CallableActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key of the meta-data value to add.";
    }

    public void setTransformer(CallableActorReference value) {
        this.m_Transformer = value;
        this.reset();
    }

    public CallableActorReference getTransformer() {
        return this.m_Transformer;
    }

    public String transformerTipText() {
        return "The callable transformer to apply to the located cells.";
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive(this.m_FlowContext, this.getTransformer());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)"key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"transformer", (Object)this.m_Transformer, (String)", transformer: ");
        return result;
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_CallableActor = this.findCallableActor();
        if (this.m_CallableActor == null) {
            result = "Couldn't find callable transformer '" + this.getTransformer() + "'!";
        } else if (!ActorUtils.isTransformer((Actor)this.m_CallableActor)) {
            result = "Callable actor '" + this.getTransformer() + "' is not a transformer!";
        }
        return result;
    }

    @Override
    protected String check(LocatedObjects objects) {
        String result = super.check(objects);
        if (result == null && this.m_CallableActor == null) {
            result = this.setUpCallableActor();
        }
        return result;
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject object : objects) {
            Object val = (object = object.getClone()).getMetaData().get(this.m_Key);
            if (val != null) {
                ((InputConsumer)this.m_CallableActor).input(new Token(val));
                String msg = this.m_CallableActor.execute();
                if (msg == null) {
                    Token output = ((OutputProducer)this.m_CallableActor).output();
                    if (output != null) {
                        object.getMetaData().put(this.m_Key, output.getPayload());
                    } else {
                        this.getLogger().warning("Callable transformer '" + this.m_Transformer + "' generated no output on input: " + val);
                    }
                } else {
                    this.getLogger().severe("Callable transformer '" + this.m_Transformer + "' failed to process input: " + val + "\n" + msg);
                }
            }
            result.add(object);
        }
        return result;
    }
}

