/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Rectangle;

public class UpdateBoundsFromPolygon
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;

    public String globalInfo() {
        return "If polygon available, updates x//width/height with bounds of polygon.";
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject obj : objects) {
            LocatedObject newObj;
            if (obj.hasPolygon()) {
                Rectangle rect = obj.getPolygon().getBounds();
                newObj = new LocatedObject(obj.getImage(), rect.x, rect.y, rect.width, rect.height, obj.getMetaData(true));
            } else {
                newObj = obj.getClone();
            }
            result.add(newObj);
        }
        return result;
    }
}

