/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.LenientModeSupporter;
import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObjects;

public abstract class AbstractObjectFinder
extends AbstractOptionHandler
implements ObjectFinder,
QuickInfoSupporter,
LenientModeSupporter {
    private static final long serialVersionUID = 2092237222859238898L;
    protected String m_Prefix;
    protected boolean m_Lenient;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("lenient", "lenient", (Object)false);
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If enabled, then no error is generated if -1 indices are returned.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"lenient", (boolean)this.m_Lenient, (String)"lenient", (String)", ");
        return result;
    }

    protected String check(LocatedObjects objects) {
        return null;
    }

    protected abstract int[] doFind(LocatedObjects var1);

    @Override
    public int[] find(LocatedObjects objects) {
        String msg = this.check(objects);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        int[] result = this.doFind(objects);
        int count = 0;
        for (int index : result) {
            if (index != -1) continue;
            ++count;
        }
        if (count > 0) {
            if (this.m_Lenient) {
                this.getLogger().warning("Number of indices returned as -1: " + count);
            } else {
                throw new IllegalStateException("Number of indices returned as -1: " + count);
            }
        }
        return result;
    }

    @Override
    public int[] find(Report report) {
        if (report == null) {
            throw new IllegalStateException("No report provided!");
        }
        return this.find(LocatedObjects.fromReport(report, this.m_Prefix));
    }

    @Override
    public LocatedObjects findObjects(LocatedObjects objects) {
        int[] indices = this.find(objects);
        return objects.subset(indices);
    }

    @Override
    public LocatedObjects findObjects(Report report) {
        return this.findObjects(LocatedObjects.fromReport(report, this.m_Prefix));
    }
}

