/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.AbstractObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.list.array.TIntArrayList;

public class HasMetaDataValue
extends AbstractObjectFinder {
    private static final long serialVersionUID = 4793599743931691992L;
    protected String m_Key;

    public String globalInfo() {
        return "Outputs the indices of objects where the specified meta-data key is present.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"");
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The meta-data key to check.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)", key: ");
        return result;
    }

    @Override
    protected int[] doFind(LocatedObjects objects) {
        TIntArrayList result = new TIntArrayList();
        for (LocatedObject obj : objects) {
            if (obj.getMetaData() == null || !obj.getMetaData().containsKey(this.m_Key)) continue;
            result.add(obj.getIndex());
        }
        return result.toArray();
    }
}

