/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.AbstractObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.list.array.TIntArrayList;

public class PolygonPoints
extends AbstractObjectFinder {
    private static final long serialVersionUID = 235661615457187608L;
    public static final String NAN = "NaN";
    protected int m_Minimum;
    protected boolean m_MinimumIncluded;
    protected int m_Maximum;
    protected boolean m_MaximumIncluded;

    public String globalInfo() {
        return "Returns the indices of objects which polygons satisfy specified min/max for number of points.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", (Object)0, (Number)0, null);
        this.m_OptionManager.add("minimum-included", "minimumIncluded", (Object)false);
        this.m_OptionManager.add("maximum", "maximum", (Object)Integer.MAX_VALUE, (Number)0, null);
        this.m_OptionManager.add("maximum-included", "maximumIncluded", (Object)false);
    }

    public void setMinimum(int value) {
        this.m_Minimum = value;
        this.reset();
    }

    public int getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum value that the #points must satisfy; use NaN (not a number) to ignore minimum.";
    }

    public void setMinimumIncluded(boolean value) {
        this.m_MinimumIncluded = value;
        this.reset();
    }

    public boolean getMinimumIncluded() {
        return this.m_MinimumIncluded;
    }

    public String minimumIncludedTipText() {
        return "If enabled, then the minimum gets included (testing '<=' rather than '<').";
    }

    public void setMaximum(int value) {
        this.m_Maximum = value;
        this.reset();
    }

    public int getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum value that the #points must satisfy; use NaN (not a number) to ignore maximum.";
    }

    public void setMaximumIncluded(boolean value) {
        this.m_MaximumIncluded = value;
        this.reset();
    }

    public boolean getMaximumIncluded() {
        return this.m_MaximumIncluded;
    }

    public String maximumIncludedTipText() {
        return "If enabled, then the maximum gets included (testing '>=' rather than '>').";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minimum", (Object)this.m_Minimum, (String)", min: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"minimumIncluded", (Object)(this.m_MinimumIncluded ? "incl" : "excl")) + "]";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maximum", (Object)this.m_Maximum, (String)", max: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"maximumIncluded", (Object)(this.m_MaximumIncluded ? "incl" : "excl")) + "]";
        return result;
    }

    @Override
    protected int[] doFind(LocatedObjects objects) {
        TIntArrayList result = new TIntArrayList();
        for (LocatedObject obj : objects) {
            if (obj.getMetaData() == null || !obj.hasPolygon()) continue;
            int points = obj.getPolygonX().length;
            boolean add = true;
            if (!Double.isNaN(this.m_Minimum)) {
                if (this.m_MinimumIncluded) {
                    if (points < this.m_Minimum) {
                        add = false;
                    }
                } else if (points <= this.m_Minimum) {
                    add = false;
                }
            }
            if (!Double.isNaN(this.m_Maximum)) {
                if (this.m_MaximumIncluded) {
                    if (points > this.m_Maximum) {
                        add = false;
                    }
                } else if (points >= this.m_Maximum) {
                    add = false;
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info(obj.getIndex() + ".  #points (" + points + ") fits: " + add);
            }
            if (!add) continue;
            result.add(obj.getIndex());
        }
        return result.toArray();
    }
}

