/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectoverlap;

import adams.core.QuickInfoHelper;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionHandler;
import adams.data.objectoverlap.AbstractObjectOverlap;
import adams.data.objectoverlap.LabelAwareObjectOverlap;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import com.github.fracpete.javautils.struct.Struct2;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class IntersectOverUnionRatio
extends AbstractObjectOverlap
implements LabelAwareObjectOverlap {
    private static final long serialVersionUID = 490981014539796857L;
    public static final String IOU_PERCENTAGE_HIGHEST = "iou_highest";
    public static final String IOU_LABEL_HIGHEST = "iou_label_highest";
    public static final String IOU_LABEL_HIGHEST_MATCH = "iou_label_highest_match";
    public static final String IOU_COUNT = "iou_count";
    protected double m_MinIntersectOverUnionRatio;
    protected String m_LabelKey;
    protected boolean m_UseOtherObject;
    protected boolean m_AdditionalObject;

    public String globalInfo() {
        return "Computes the Intersect Over Union (IOU) between annotations and predictions.\nIt stores the IOU percentage of the highest IOU found (iou_highest) and the total number of IOU greater than the specified minimum (iou_count).\nIf a label key (located object meta-data) has been supplied, then the label of the object with the highest IOU gets stored as well (iou_label_highest) and whether the labels match (iou_label_highest_match)";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-iou-ratio", "minIntersectOverUnionRatio", (Object)0.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("label-key", "labelKey", (Object)"");
        this.m_OptionManager.add("use-other-object", "useOtherObject", (Object)false);
        this.m_OptionManager.add("additional-object", "additionalObject", (Object)false);
    }

    public void setMinIntersectOverUnionRatio(double value) {
        if (this.getOptionManager().isValid("minIntersectOverUnionRatio", (Number)value)) {
            this.m_MinIntersectOverUnionRatio = value;
            this.reset();
        }
    }

    public double getMinIntersectOverUnionRatio() {
        return this.m_MinIntersectOverUnionRatio;
    }

    public String minIntersectOverUnionRatioTipText() {
        return "The minimum ratio that an IOU must have before being considered an actual overlap.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The (optional) key for a string label in the meta-data; if supplied the value of the object with the highest IOU gets stored in the report using iou_label_highest, iou_label_highest_match stores whether the labels match.";
    }

    public void setUseOtherObject(boolean value) {
        this.m_UseOtherObject = value;
        this.reset();
    }

    public boolean getUseOtherObject() {
        return this.m_UseOtherObject;
    }

    public String useOtherObjectTipText() {
        return "If enabled, the object data from the other report is used/forwarded in case of an overlap.";
    }

    public void setAdditionalObject(boolean value) {
        this.m_AdditionalObject = value;
        this.reset();
    }

    public boolean getAdditionalObject() {
        return this.m_AdditionalObject;
    }

    public String additionalObjectTipText() {
        return "If enabled, the additional predicted objects not present in actual objects will be checked.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"minIntersectOverUnionRatio", (Object)this.m_MinIntersectOverUnionRatio, (String)"ratio: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labelKey", (Object)(this.m_LabelKey.isEmpty() ? "-none-" : this.m_LabelKey), (String)", label key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"useOtherObject", (boolean)this.m_UseOtherObject, (String)"use other obj", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"additionalObject", (boolean)this.m_AdditionalObject, (String)"additional obj", (String)", ");
        return result;
    }

    @Override
    protected LocatedObjects doCalculate(LocatedObjects annotations, LocatedObjects predictions, Map<LocatedObject, Set<LocatedObject>> matches) {
        LocatedObjects result = new LocatedObjects();
        if (annotations.size() == 0) {
            result = predictions;
        } else {
            HashSet<LocatedObject> matchingObjects = new HashSet<LocatedObject>();
            for (LocatedObject thisObj : annotations) {
                if (this.isLoggingEnabled()) {
                    if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
                        this.getLogger().info("this: " + thisObj + " (" + thisObj.getMetaData() + ")");
                    } else {
                        this.getLogger().info("this: " + thisObj);
                    }
                }
                int count = 0;
                double iouHighest = 0.0;
                String labelHighest = "???";
                String thisLabel = "???";
                if (!this.m_LabelKey.isEmpty() && thisObj.getMetaData().containsKey(this.m_LabelKey)) {
                    thisLabel = "" + thisObj.getMetaData().get(this.m_LabelKey);
                }
                LocatedObject actObj = thisObj;
                LocatedObject otherObjectHighest = null;
                for (LocatedObject otherObj : predictions) {
                    this.initMatch(matches, thisObj);
                    if (this.m_ExcludeIdentical && thisObj.equals(otherObj)) continue;
                    double ratio = thisObj.overlapRatio(otherObj);
                    double thisObjArea = thisObj.getHeight() * thisObj.getWidth();
                    double intersectArea = thisObjArea * ratio;
                    double otherObjArea = otherObj.getHeight() * otherObj.getWidth();
                    double iou = intersectArea / (thisObjArea + otherObjArea - intersectArea);
                    if (this.isLoggingEnabled()) {
                        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
                            this.getLogger().info(" + other: " + otherObj + " (" + otherObj.getMetaData() + ") -> IOU = " + iou);
                        } else {
                            this.getLogger().info(" + other: " + otherObj + " -> IOU = " + iou);
                        }
                    }
                    if (!(iou >= this.m_MinIntersectOverUnionRatio)) continue;
                    ++count;
                    this.addMatch(matches, thisObj, otherObj);
                    if (!(iou > iouHighest)) continue;
                    LocatedObject tmpObj = null;
                    if (this.m_UseOtherObject) {
                        tmpObj = actObj;
                        actObj = otherObj;
                    }
                    iouHighest = iou;
                    otherObjectHighest = otherObj;
                    if (!this.m_LabelKey.isEmpty()) {
                        if (otherObj.getMetaData().containsKey(this.m_LabelKey)) {
                            labelHighest = "" + otherObj.getMetaData().get(this.m_LabelKey);
                            matchingObjects.add(otherObj);
                        } else {
                            labelHighest = "???";
                        }
                    } else {
                        matchingObjects.add(otherObj);
                    }
                    if (!this.m_UseOtherObject) continue;
                    otherObj = tmpObj;
                }
                actObj = actObj.getClone();
                actObj.getMetaData().put(IOU_COUNT, count);
                actObj.getMetaData().put(IOU_PERCENTAGE_HIGHEST, iouHighest);
                if (!this.m_LabelKey.isEmpty()) {
                    actObj.getMetaData().put(IOU_LABEL_HIGHEST, labelHighest);
                    actObj.getMetaData().put(IOU_LABEL_HIGHEST_MATCH, thisLabel.equals(labelHighest));
                }
                if (this.m_AdditionalObject) {
                    actObj.getMetaData().put("additional_object", false);
                }
                if (this.m_CopyMetaData && otherObjectHighest != null) {
                    this.copyMetaData(otherObjectHighest, actObj);
                }
                result.add(actObj);
            }
            if (this.m_AdditionalObject) {
                for (LocatedObject otherObj : predictions) {
                    if (matchingObjects.contains(otherObj)) continue;
                    otherObj = otherObj.getClone();
                    otherObj.getMetaData().put("additional_object", true);
                    result.add(otherObj);
                }
            }
        }
        return result;
    }

    @Override
    public Struct2<LocatedObjects, LocatedObjects> splitOverlaps(LocatedObjects overlaps) {
        LocatedObjects match = new LocatedObjects();
        LocatedObjects mismatch = new LocatedObjects();
        for (LocatedObject overlap : overlaps) {
            if (overlap.getMetaData().getOrDefault(IOU_LABEL_HIGHEST_MATCH, false).toString().equalsIgnoreCase("true")) {
                match.add(overlap.getClone());
                continue;
            }
            mismatch.add(overlap.getClone());
        }
        return new Struct2((Object)match, (Object)mismatch);
    }
}

