/*
 * Decompiled with CFR 0.152.
 */
package adams.data.overlappingobjectremoval;

import adams.core.option.AbstractOptionHandler;
import adams.data.objectfinder.ObjectFinder;
import adams.data.objectoverlap.ObjectOverlap;
import adams.data.overlappingobjectremoval.OverlappingObjectRemoval;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.Map;
import java.util.Set;

public abstract class AbstractOverlappingObjectRemoval
extends AbstractOptionHandler
implements OverlappingObjectRemoval {
    private static final long serialVersionUID = 6991707947586230873L;

    @Override
    public abstract LocatedObjects removeOverlaps(LocatedObjects var1, Map<LocatedObject, Set<LocatedObject>> var2);

    public static Report remove(Report thisReport, Report otherReport, ObjectFinder finder, ObjectOverlap detection, OverlappingObjectRemoval removal) throws Exception {
        LocatedObjects thisObjs = finder.findObjects(LocatedObjects.fromReport(thisReport, finder.getPrefix()));
        LocatedObjects otherObjs = finder.findObjects(LocatedObjects.fromReport(otherReport, finder.getPrefix()));
        Map<LocatedObject, Set<LocatedObject>> matches = detection.matches(thisObjs, otherObjs);
        LocatedObjects newObjs = removal.removeOverlaps(thisObjs, matches);
        Report result = (Report)thisReport.getClass().newInstance();
        for (AbstractField field : thisReport.getFields()) {
            if (field.getName().startsWith(finder.getPrefix())) continue;
            result.addField(field);
            result.setValue(field, thisReport.getValue(field));
        }
        result.mergeWith(newObjs.toReport(finder.getPrefix()));
        return result;
    }
}

