/*
 * Decompiled with CFR 0.152.
 */
package adams.data.overlappingobjectremoval;

import adams.data.overlappingobjectremoval.AbstractOverlappingObjectRemoval;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.Map;
import java.util.Set;

public class KeepHighestMetaDataValue
extends AbstractOverlappingObjectRemoval {
    private static final long serialVersionUID = -895136411948961806L;
    protected String m_ScoreKey;

    public String globalInfo() {
        return "Keeps object with the highest (numeric) meta-data value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("score-key", "scoreKey", (Object)"");
    }

    public void setScoreKey(String value) {
        this.m_ScoreKey = value;
        this.reset();
    }

    public String getScoreKey() {
        return this.m_ScoreKey;
    }

    public String labelKeyTipText() {
        return "The key for the (numeric) score in the meta-data.";
    }

    @Override
    public LocatedObjects removeOverlaps(LocatedObjects objects, Map<LocatedObject, Set<LocatedObject>> matches) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject thisObj : objects) {
            Set<LocatedObject> others = matches.get(thisObj);
            if (others != null && others.size() > 0) {
                double thisScore;
                LocatedObject keep = thisObj;
                double currScore = thisScore = ((Double)thisObj.getMetaData().getOrDefault(this.m_ScoreKey, 0.0)).doubleValue();
                for (LocatedObject otherObj : others) {
                    double otherScore = (Double)otherObj.getMetaData().getOrDefault(this.m_ScoreKey, 0.0);
                    if (!(otherScore > currScore)) continue;
                    keep = otherObj;
                    currScore = otherScore;
                }
                result.add(keep.getClone());
                continue;
            }
            result.add(thisObj.getClone());
        }
        return result;
    }
}

