/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ImageSegmentationContainer
extends AbstractContainer {
    private static final long serialVersionUID = -472411106843171690L;
    public static final String VALUE_NAME = "name";
    public static final String VALUE_BASE = "base";
    public static final String VALUE_LAYERS = "layers";

    public ImageSegmentationContainer() {
    }

    public ImageSegmentationContainer(String name, BufferedImage base) {
        this(name, base, null);
    }

    public ImageSegmentationContainer(String name, BufferedImage base, Map<String, BufferedImage> layers) {
        this();
        this.store(VALUE_NAME, name);
        this.store(VALUE_BASE, base);
        this.store(VALUE_LAYERS, layers);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_NAME, "image name", String.class);
        this.addHelp(VALUE_BASE, "base image", BufferedImage.class);
        this.addHelp(VALUE_LAYERS, "map of layers (name -> BufferedImage)", Map.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_NAME);
        result.add(VALUE_BASE);
        result.add(VALUE_LAYERS);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_NAME) && this.hasValue(VALUE_BASE);
    }

    public BufferedImage getBaseImage() {
        return (BufferedImage)this.getValue(VALUE_BASE);
    }
}

