/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.PassThrough;
import adams.data.jai.JAIHelper;
import adams.flow.core.Actor;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.Arrays;

public class BufferedImageTransformer
extends AbstractArrayProvider {
    private static final long serialVersionUID = 3690378527551302472L;
    protected AbstractBufferedImageTransformer m_TransformAlgorithm;

    public String globalInfo() {
        return "Applies a BufferedImage transformation to the incoming image and outputs the generated image(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformAlgorithm", (Object)new PassThrough());
    }

    public String outputArrayTipText() {
        return "Whether to output the images as an array or one-by-one.";
    }

    public void setTransformAlgorithm(AbstractBufferedImageTransformer value) {
        this.m_TransformAlgorithm = value;
        this.reset();
    }

    public AbstractBufferedImageTransformer getTransformAlgorithm() {
        return this.m_TransformAlgorithm;
    }

    public String transformAlgorithmTipText() {
        return "The transformer to use for transformering the image.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"transformAlgorithm", (Object)((Object)this.m_TransformAlgorithm));
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)(this.m_OutputArray ? "as array" : ""), (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    protected Class getItemClass() {
        return BufferedImageContainer.class;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_TransformAlgorithm.setFlowContext((Actor)this);
            BufferedImageContainer img = JAIHelper.toBufferedImageContainer((AbstractImageContainer)this.m_InputToken.getPayload());
            this.m_Queue.clear();
            this.m_Queue.addAll(Arrays.asList((BufferedImageContainer[])this.m_TransformAlgorithm.transform((AbstractImageContainer)img)));
            this.m_TransformAlgorithm.setFlowContext(null);
        }
        catch (Exception e) {
            result = this.handleException("Failed to transform image: ", e);
        }
        return result;
    }
}

