/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class ChangeImageObjectPrefix
extends AbstractTransformer {
    private static final long serialVersionUID = -3992867498417362738L;
    protected String m_PrefixNew;
    protected ObjectFinder m_Finder;

    public String globalInfo() {
        return "Uses the specified object finder to locate objects and then applies the object filter to the located objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix-new", "prefixNew", (Object)"Other.");
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
    }

    public void setPrefixNew(String value) {
        this.m_PrefixNew = value;
        this.reset();
    }

    public String getPrefixNew() {
        return this.m_PrefixNew;
    }

    public String prefixNewTipText() {
        return "The new report field prefix to be used in the report.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public Class[] accepts() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"prefixNew", (Object)this.m_PrefixNew, (String)", new: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        MutableReportHandler handler = null;
        if (this.m_InputToken.hasPayload(MutableReportHandler.class)) {
            handler = (MutableReportHandler)this.m_InputToken.getPayload(MutableReportHandler.class);
            report = handler.getReport();
        } else if (this.m_InputToken.hasPayload(Report.class)) {
            report = (Report)this.m_InputToken.getPayload(Report.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            try {
                LocatedObjects objs = LocatedObjects.fromReport(report, this.m_Finder.getPrefix());
                int[] indices = this.m_Finder.find(report);
                for (AbstractField field : report.getFields()) {
                    if (!field.getName().startsWith(this.m_Finder.getPrefix())) continue;
                    report.removeValue(field);
                }
                LocatedObjects newObjs = objs.subset(indices);
                objs.remove(indices);
                Report newReport = newObjs.toReport(this.m_PrefixNew);
                for (AbstractField field : newReport.getFields()) {
                    report.addField(field);
                    report.setValue(field, newReport.getValue(field));
                }
                newReport = objs.toReport(this.m_Finder.getPrefix());
                for (AbstractField field : newReport.getFields()) {
                    report.addField(field);
                    report.setValue(field, newReport.getValue(field));
                }
                if (handler != null) {
                    handler.setReport(report);
                    this.m_OutputToken = new Token((Object)handler);
                } else {
                    this.m_OutputToken = new Token((Object)report);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to filter objects!", e);
            }
        }
        return result;
    }
}

